/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.bean;

import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.exception.TunnelingException;
import de.intarsys.tools.functor.FunctorCall;
import de.intarsys.tools.functor.IFunctor;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;

public class ScriptedLifecycleBean
implements IElementConfigurable {
    private IElement element;

    @Override
    public void configure(IElement pElement) throws ConfigurationException {
        this.element = pElement;
    }

    public IElement getElement() {
        return this.element;
    }

    @PostConstruct
    public void postConstruct() {
        try {
            IElement elFunctor = this.getElement().element("postConstruct");
            IFunctor<?> functor = ElementTools.createFunctor(this, elFunctor, null, null);
            if (functor != null) {
                functor.perform(FunctorCall.create(this, new Object[0]));
            }
        }
        catch (Exception e) {
            throw new TunnelingException(e);
        }
    }

    @PreDestroy
    public void preDestroy() {
        try {
            IElement elFunctor = this.getElement().element("preDestroy");
            IFunctor<?> functor = ElementTools.createFunctor(this, elFunctor, null, null);
            if (functor != null) {
                functor.perform(FunctorCall.create(this, new Object[0]));
            }
        }
        catch (Exception e) {
            throw new TunnelingException(e);
        }
    }

    public void setElement(IElement element) {
        this.element = element;
    }
}

