/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.authenticate;

import de.intarsys.tools.activity.IPrompter;
import de.intarsys.tools.authenticate.IPasswordProvider;
import de.intarsys.tools.crypto.CryptoTools;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.message.IMessage;
import java.util.HashMap;
import java.util.Map;

public class CachedPasswordProvider
implements IPasswordProvider,
IPrompter {
    private Secret password;
    private final Map<String, Secret> passwords = new HashMap<String, Secret>();
    private final IPasswordProvider passwordProvider;

    public CachedPasswordProvider(IPasswordProvider passwordProvider) {
        this.passwordProvider = passwordProvider;
    }

    @Override
    public Secret getPassword() {
        if (!CryptoTools.isEmpty(this.password)) {
            return this.password;
        }
        this.password = this.getPasswordProvider().getPassword();
        return this.password;
    }

    @Override
    public Secret getPassword(IPasswordProvider.PasswordRequestOptions options) {
        String id;
        if (this.passwordProvider instanceof IPrompter) {
            ((IPrompter)((Object)this.passwordProvider)).setTitle(options.getTitle());
            ((IPrompter)((Object)this.passwordProvider)).setMessage(options.getMessage());
        }
        if ((id = options.getPasswordId()) == null) {
            return this.getPassword();
        }
        Secret secret = this.passwords.get(id);
        if (CryptoTools.isEmpty(secret)) {
            secret = this.getPasswordProvider().getPassword();
            this.passwords.put(id, secret);
        }
        return secret;
    }

    public IPasswordProvider getPasswordProvider() {
        return this.passwordProvider;
    }

    @Override
    public void setMessage(IMessage message) {
        if (this.getPasswordProvider() instanceof IPrompter) {
            ((IPrompter)((Object)this.passwordProvider)).setMessage(message);
        }
    }

    @Override
    public void setTitle(IMessage title) {
        if (this.getPasswordProvider() instanceof IPrompter) {
            ((IPrompter)((Object)this.passwordProvider)).setTitle(title);
        }
    }
}

