/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.activity;

import de.intarsys.tools.activity.IInteraction;
import de.intarsys.tools.concurrent.CompletionStageTools;
import de.intarsys.tools.concurrent.ICompletable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class SimpleInteraction<M, R>
implements IInteraction<M, R> {
    private final M model;
    private final CompletableFuture<R> future;
    private final ICompletable<R> completable = new ICompletable(){

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return SimpleInteraction.this.future.cancel(mayInterruptIfRunning);
        }

        @Override
        public void fail(Throwable t) {
            SimpleInteraction.this.future.completeExceptionally(t);
        }

        @Override
        public void finish() {
            SimpleInteraction.this.future.complete(null);
        }

        @Override
        public R get() throws InterruptedException, ExecutionException {
            return SimpleInteraction.this.future.get();
        }

        @Override
        public R get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return SimpleInteraction.this.future.get(timeout, unit);
        }

        @Override
        public boolean isCancelled() {
            return SimpleInteraction.this.future.isCancelled();
        }

        @Override
        public boolean isDone() {
            return SimpleInteraction.this.future.isDone();
        }
    };
    private final CompletionStage<R> stage;

    public static <M, R> SimpleInteraction<M, Void> completed(M model, R result) {
        CompletableFuture<R> completable = CompletableFuture.completedFuture(result);
        return new SimpleInteraction<M, R>(model, completable, completable);
    }

    public static <M> SimpleInteraction<M, Void> failed(M model, Throwable ex) {
        CompletableFuture completable = CompletionStageTools.failedFuture(ex);
        return new SimpleInteraction(model, completable, completable);
    }

    public SimpleInteraction(M model, CompletableFuture<R> completable, CompletionStage<R> stage) {
        this.model = model;
        this.future = completable;
        this.stage = stage;
    }

    @Override
    public ICompletable<R> getCompletable() {
        return this.completable;
    }

    @Override
    public M getModel() {
        return this.model;
    }

    @Override
    public CompletionStage getStage() {
        return this.stage;
    }
}

