/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.action;

import de.intarsys.tools.action.ActionAdapter;
import de.intarsys.tools.action.ActionRegistry;
import de.intarsys.tools.action.IAction;
import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.category.CategoryRegistry;
import de.intarsys.tools.category.ICategory;
import de.intarsys.tools.category.ICategorySupport;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.component.IContextSupport;
import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventDispatcher;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.exception.InvalidRequestException;
import de.intarsys.tools.functor.FunctorException;
import de.intarsys.tools.functor.IFunctorCall;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.IAttribute;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.infoset.IElementSerializable;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.presentation.IPresentationSupport;
import de.intarsys.tools.reflect.IClassLoaderAccess;
import de.intarsys.tools.string.StringTools;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Action
extends ActionAdapter
implements IClassLoaderAccess,
Comparable,
IElementConfigurable,
IElementSerializable,
ICategorySupport,
IContextSupport {
    private static final Logger Log = LoggerFactory.getLogger(Action.class);
    private static final String STYLE_CHECK = "check";
    private static final String ATTR_STYLE = "style";
    private static final String ATTR_ICON = "icon";
    private static final String ATTR_DESCRIPTION = "description";
    private static final String ATTR_TIP = "tip";
    private static final String ATTR_LABEL = "label";
    private static final String ATTR_ID = "id";
    private static final String ATTR_CATEGORY = "category";
    private AttributeMap attributes;
    private boolean checked;
    private ClassLoader classLoader;
    private Object description;
    private EventDispatcher dispatcher;
    private IElement element;
    private boolean enabled = true;
    private String iconName;
    private String id;
    private Object label;
    private Object owner;
    private boolean pushStyle = true;
    private Object tip;
    private ICategory category;

    protected Action() {
        this(null, null);
    }

    protected Action(Object owner) {
        this(null, owner);
    }

    protected Action(Object owner, boolean checked) {
        this(null, owner, checked);
    }

    protected Action(String id, Object owner) {
        this.id = id == null ? this.getDefaultId() : id;
        this.setOwner(owner);
    }

    protected Action(String id, Object owner, boolean checked) {
        this(id, owner);
        this.setCheckStyleOn();
        this.setChecked(checked);
    }

    @Override
    public void addNotificationListener(EventType type, INotificationListener listener) {
        if (this.dispatcher == null) {
            this.dispatcher = new EventDispatcher(this);
        }
        this.dispatcher.addNotificationListener(type, listener);
    }

    public int compareTo(Object other) {
        if (other instanceof IAction) {
            return this.getId().compareTo(((IAction)other).getId());
        }
        return 1;
    }

    @Override
    public void configure(IElement pElement) throws ConfigurationException {
        this.element = pElement;
        this.setId(pElement.attributeValue(ATTR_ID, null));
        IAttribute attribute = this.element.attribute(ATTR_LABEL);
        if (attribute != null) {
            this.setLabel(attribute.getData());
        }
        if ((attribute = this.element.attribute(ATTR_TIP)) != null) {
            this.setTip(attribute.getData());
        }
        if ((attribute = this.element.attribute(ATTR_DESCRIPTION)) != null) {
            this.setDescription(attribute.getData());
        }
        this.setIconName(this.element.attributeValue(ATTR_ICON, null));
        this.setStyle(this.element.attributeValue(ATTR_STYLE, null));
        if (this.getCategory() == null) {
            String categoryId = pElement.attributeValue(ATTR_CATEGORY, "de.intarsys.category.other");
            this.setCategory(CategoryRegistry.get().lookupCategory(categoryId));
        }
    }

    @Override
    public final Object getAttribute(Object key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.getAttribute(key);
    }

    @Override
    public ICategory getCategory() {
        return this.category;
    }

    @Override
    public ClassLoader getClassLoader() {
        ClassLoader result = this.classLoader;
        if (result == null) {
            result = this.getOwner() == null ? this.getClass().getClassLoader() : this.getOwner().getClass().getClassLoader();
        }
        return result;
    }

    protected String getDefaultDescription() {
        return this.getTip();
    }

    protected String getDefaultIconName() {
        return null;
    }

    private String getDefaultId() {
        return this.getClass().getName();
    }

    protected String getDefaultLabel() {
        if (this.getId() == null) {
            return "No Name";
        }
        return this.getId();
    }

    protected String getDefaultTip() {
        return this.getLabel();
    }

    @Override
    public String getDescription() {
        if (this.description == null) {
            return this.getDefaultDescription();
        }
        if (this.description instanceof IMessage) {
            return ((IMessage)this.description).getString();
        }
        return (String)this.description;
    }

    public IElement getElement() {
        return this.element;
    }

    @Override
    public String getIconName() {
        if (this.iconName == null) {
            return this.getDefaultIconName();
        }
        return this.iconName;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getLabel() {
        if (this.label == null) {
            return this.getDefaultLabel();
        }
        if (this.label instanceof IMessage) {
            return ((IMessage)this.label).getString();
        }
        return (String)this.label;
    }

    public Object getOwner() {
        return this.owner;
    }

    protected String getSerializeIconName() {
        return this.iconName;
    }

    protected String getSerializeId() {
        return this.id;
    }

    @Override
    public String getTip() {
        if (this.tip == null) {
            return this.getDefaultTip();
        }
        if (this.tip instanceof IMessage) {
            return ((IMessage)this.tip).getString();
        }
        return (String)this.tip;
    }

    @Override
    public boolean isChecked(IFunctorCall call) {
        return this.checked;
    }

    @Override
    public boolean isCheckStyle() {
        return !this.isPushStyle();
    }

    @Override
    public boolean isEnabled(IFunctorCall call) {
        return this.enabled;
    }

    @Override
    public boolean isPushStyle() {
        return this.pushStyle;
    }

    public Object perform() throws FunctorException {
        return null;
    }

    @Override
    public Object perform(IFunctorCall call) throws FunctorException {
        return this.perform();
    }

    @PostConstruct
    public void register() {
        String myId = this.getId();
        if (ActionRegistry.get().lookupAction(myId) != null) {
            Log.warn("action '" + myId + "' redefined");
        }
        ActionRegistry.get().registerAction(this);
    }

    @Override
    public final Object removeAttribute(Object key) {
        if (this.attributes == null) {
            return null;
        }
        Object result = this.attributes.removeAttribute(key);
        this.triggerChange(key);
        return result;
    }

    @Override
    public void removeNotificationListener(EventType type, INotificationListener listener) {
        if (this.dispatcher == null) {
            return;
        }
        this.dispatcher.removeNotificationListener(type, listener);
    }

    @Override
    public void serialize(IElement element) throws ElementSerializationException {
        element.setName("object");
        element.setAttributeValue("class", this.getClass().getName());
        element.setAttributeValue(ATTR_ID, this.getId());
        if (this.label != null) {
            element.setAttributeValue(ATTR_LABEL, this.getLabel());
        }
        if (this.tip != null) {
            element.setAttributeValue(ATTR_TIP, this.getTip());
        }
        if (this.description != null) {
            element.setAttributeValue(ATTR_DESCRIPTION, this.getDescription());
        }
        if (!StringTools.isEmpty(this.getIconName())) {
            element.setAttributeValue(ATTR_ICON, this.getIconName());
        }
        if (this.isCheckStyle()) {
            element.setAttributeValue(ATTR_STYLE, STYLE_CHECK);
        }
        if (this.getCategory() != null) {
            element.setAttributeValue(ATTR_CATEGORY, this.getCategory().getId());
        }
    }

    @Override
    public final Object setAttribute(Object key, Object value) {
        if (this.attributes == null) {
            this.attributes = new AttributeMap(1);
        }
        Object result = this.attributes.setAttribute(key, value);
        this.triggerChange(key);
        return result;
    }

    public void setCategory(ICategory category) {
        this.category = category;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
        this.triggerChange("checked");
    }

    public void setCheckStyleOn() {
        this.pushStyle = false;
        this.triggerChange(ATTR_STYLE);
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public void setContext(Object context) throws ConfigurationException {
        this.setOwner(context);
    }

    public void setDescription(Object description) {
        this.description = description;
        this.triggerChange(IPresentationSupport.ATTR_DESCRIPTION);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.triggerChange("enabled");
    }

    public void setIconName(String iconName) {
        this.iconName = iconName;
        this.triggerChange(IPresentationSupport.ATTR_ICON);
    }

    public void setId(String id) {
        this.id = id;
        this.triggerChange(ATTR_ID);
    }

    public void setLabel(Object label) {
        this.label = label;
        this.triggerChange(IPresentationSupport.ATTR_LABEL);
    }

    public void setOwner(Object owner) {
        if (this.owner != null) {
            throw new InvalidRequestException("can not reassign owner");
        }
        this.owner = owner;
    }

    public void setPushStyleOn() {
        this.pushStyle = true;
        this.triggerChange(ATTR_STYLE);
    }

    public void setStyle(String style) {
        if (style == null) {
            return;
        }
        if (style.indexOf(STYLE_CHECK) != -1) {
            this.setCheckStyleOn();
        }
    }

    public void setTip(Object shortDescription) {
        this.tip = shortDescription;
        this.triggerChange(IPresentationSupport.ATTR_TIP);
    }

    public String toString() {
        try {
            return "Action '" + this.getId() + "'";
        }
        catch (RuntimeException e) {
            return "<unprintable Action>";
        }
    }

    @Override
    public void touch() {
        this.triggerChange(null);
    }

    protected void triggerChange(Object attribute) {
        if (this.dispatcher == null) {
            return;
        }
        AttributeChangedEvent event = new AttributeChangedEvent(this, attribute, null, null);
        this.triggerEvent(event);
    }

    protected void triggerEvent(Event event) {
        if (this.dispatcher == null) {
            return;
        }
        this.dispatcher.triggerEvent(event);
    }
}

