/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.egov.validationclient.sdk;

import ch.admin.suis.client.core.service.IValidationServiceClient;
import ch.admin.suis.client.core.service.to.FileRequest;
import ch.admin.suis.client.core.service.to.PdfEntry;
import ch.admin.suis.client.core.service.to.StreamRequest;
import ch.admin.suis.client.core.service.to.UserRequest;
import ch.admin.suis.validator.rest.to.Mandator;
import ch.admin.suis.validator.rest.to.ServiceInput;
import ch.admin.suis.validator.rest.to.SignatureTO;
import ch.admin.suis.validator.rest.to.response.FileReport;
import ch.admin.suis.validator.rest.to.response.SignatureReport;
import ch.admin.suis.validator.rest.to.response.ValidatableFile;
import ch.admin.suis.validator.rest.to.response.ValidationResponse;
import de.intarsys.egov.validationclient.sdk.PACKAGE;
import de.intarsys.egov.validationclient.sdk.ServiceInputBuilder;
import de.intarsys.tools.application.ApplicationComponent;
import de.intarsys.tools.collection.MapTools;
import de.intarsys.tools.exception.UnreachableCodeError;
import de.intarsys.tools.license.LicenseEnvironment;
import de.intarsys.tools.license.LicenseException;
import de.intarsys.tools.license.LicenseLoader;
import de.intarsys.tools.license.LicenseProduct;
import de.intarsys.tools.license.LicenseRepository;
import de.intarsys.tools.license.LicenseTools;
import de.intarsys.tools.locator.ByteArrayLocator;
import de.intarsys.tools.locator.ILocator;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import org.bouncycastle.cms.CMSSignedData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EGovValidationServiceClient
implements IValidationServiceClient {
    private static final String API_PATH = "service/api";
    private static final String LICENSE_PATH = "service/api/license";
    private static final String PRODUCT_ID = "de.intarsys.product.egov.validationclient";
    private static final LicenseProduct LICENSE_PRODUCT;
    private static final Logger Log;
    private final WebTarget target;

    public EGovValidationServiceClient(WebTarget target) {
        this.target = target;
        this.loadLicenses();
    }

    protected void checkLicense() {
        if (!LicenseEnvironment.get().getLicenseProductState(LICENSE_PRODUCT).isAuthorized()) {
            throw new LicenseException("No valid license found.");
        }
    }

    protected LicenseProduct createLicenseProduct() {
        LicenseProduct product = new LicenseProduct();
        product.setId(PRODUCT_ID);
        product.setVersion(ApplicationComponent.get().getVersion());
        product.setMain(true);
        product.setContext((Object)this);
        return product;
    }

    public Mandator[] getAllMandators(Locale locale) {
        this.checkLicense();
        try {
            return this.invokeTarget("service/getMandators", null, MapTools.with((Object[])new Object[]{"language", locale.getLanguage()}), Mandator[].class);
        }
        catch (IOException ex) {
            Log.error(ex.getMessage(), (Throwable)ex);
            return new Mandator[0];
        }
    }

    protected <T> T invokeTarget(String path, Object request, Map<String, Object> query, Class<T> responseClass) throws IOException {
        WebTarget target = this.target.path(path);
        if (query != null) {
            query.forEach((key, value) -> target.queryParam(key, new Object[]{value}));
        }
        Invocation.Builder builder = target.request().accept(new String[]{"application/json"});
        if (request == null) {
            return (T)builder.get(responseClass);
        }
        return (T)builder.post(Entity.entity((Object)request, (String)"application/json"), responseClass);
    }

    protected ValidationResponse invokeTarget(String path, ServiceInput serviceInput, boolean log) throws IOException {
        ValidationResponse validationResponse = this.invokeTarget(path, serviceInput, null, ValidationResponse.class);
        if (log) {
            Log.info("Request = " + serviceInput);
            for (ValidatableFile validatableFile : serviceInput.getValidatableFiles()) {
                Log.info("Files to validate :");
                Log.info(validatableFile.toString());
                Log.info("Signatures in {} :", (Object)validatableFile.getDocumentName());
                for (SignatureTO sig : validatableFile.getSignatures()) {
                    Log.info(sig.toString());
                }
            }
            Log.info("Response = {}", (Object)validationResponse);
            Log.info("File reports:");
            for (FileReport fileReport : validationResponse.getFileReports()) {
                Log.info(fileReport.toString());
                Log.info("Validity of file report is {}", (Object)fileReport.isValid());
                Log.info("Document modified after last signature: " + fileReport.isDocModifiedAfterLastSignature());
                for (SignatureReport signatureReport : fileReport.getSignatureReports()) {
                    Log.info("Signature {} is {}", (Object)signatureReport.getSignatureName(), (Object)signatureReport.isValid());
                }
            }
        }
        return validationResponse;
    }

    protected void loadLicense(WebTarget target, LicenseRepository licenseRepository) {
        byte[] licenseData;
        try {
            licenseData = (byte[])target.request().accept(new String[]{"application/xml"}).get(byte[].class);
        }
        catch (Exception e) {
            Log.info("no license available at '" + target.getUri() + "'", (Throwable)e);
            Log.trace("error fetching license: " + e.getMessage(), (Throwable)e);
            return;
        }
        ByteArrayLocator licenseLocator = new ByteArrayLocator(licenseData, "license.lic");
        try {
            List licenses = LicenseTools.loadLicense((ILocator)licenseLocator);
            licenses.stream().forEach(license -> licenseRepository.addLicense(license));
            Log.info("loaded license from '{}'", (Object)target.getUri());
        }
        catch (LicenseException e) {
            Log.info("cannot load license from '" + target.getUri() + "'");
            Log.trace("error loading license: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void loadLicenses() {
        LicenseLoader licenseLoader = new LicenseLoader();
        licenseLoader.setLocation("classpath:license.lic");
        licenseLoader.install();
        WebTarget licenseTarget = this.target.path(LICENSE_PATH);
        this.loadLicense(licenseTarget, LicenseEnvironment.get().getLicenseRepositoryRoot());
    }

    public List<ValidationResponse> validateMultipleRequests(UserRequest request, boolean pdfReport) throws NoSuchAlgorithmException, IOException {
        return this.validateMultipleRequests(request, pdfReport, false);
    }

    public List<ValidationResponse> validateMultipleRequests(UserRequest userRequest, boolean pdfReport, boolean doLogs) throws NoSuchAlgorithmException, IOException {
        this.checkLicense();
        ArrayList<ValidationResponse> validationResponses = new ArrayList<ValidationResponse>();
        HashSet<PdfEntry> seen = new HashSet<PdfEntry>();
        Stack<PdfEntry> stack = new Stack<PdfEntry>();
        stack.add(userRequest.getRootNode());
        while (!stack.isEmpty()) {
            PdfEntry pdfEntry = (PdfEntry)stack.pop();
            if (seen.contains(pdfEntry)) continue;
            seen.add(pdfEntry);
            stack.addAll(pdfEntry.getChildren());
            if (!pdfEntry.isCheck()) continue;
            validationResponses.add(this.validateOneSignature(pdfEntry.getFilePart(), pdfEntry.getChosenClient(), pdfReport, pdfEntry.getName(), userRequest.getChosenFile().getName(), userRequest.getUserOrg(), userRequest.getUserName(), userRequest.getLanguage(), pdfEntry.getChosenFileName(), doLogs));
        }
        return validationResponses;
    }

    public ValidationResponse validateOneRequest(List<FileRequest> filesToValidate, boolean pdfReport, String userOrganization, String userName, String language, String pdfReportName) throws NoSuchAlgorithmException, IOException, IllegalArgumentException {
        return this.validateOneRequest(filesToValidate, pdfReport, userOrganization, userName, language, pdfReportName, false, false);
    }

    public ValidationResponse validateOneRequest(List<FileRequest> filesToValidate, boolean pdfReport, String userOrganization, String userName, String language, String pdfReportName, boolean doLogs) throws NoSuchAlgorithmException, IOException, IllegalArgumentException {
        return this.validateOneRequest(filesToValidate, pdfReport, userOrganization, userName, language, pdfReportName, doLogs, false);
    }

    public ValidationResponse validateOneRequest(List<FileRequest> filesToValidate, boolean pdfReport, String userOrganization, String userName, String language, String pdfReportName, boolean doLogs, boolean processUnsignedFiles) throws NoSuchAlgorithmException, IOException, IllegalArgumentException {
        this.checkLicense();
        ServiceInput request = new ServiceInputBuilder().addFileRequests(filesToValidate).userName(userName).userOrganization(userOrganization).language(language).pdfReport(pdfReport).pdfReportName(pdfReportName).processUnsignedFiles(processUnsignedFiles).build();
        return this.invokeTarget(API_PATH, request, doLogs);
    }

    public ValidationResponse validateOneRequestS(List<StreamRequest> filesToValidate, boolean pdfReport, String userOrganization, String userName, String language, String pdfReportName) throws NoSuchAlgorithmException, IOException, IllegalArgumentException {
        return this.validateOneRequestS(filesToValidate, pdfReport, userOrganization, userName, language, pdfReportName, false, false);
    }

    public ValidationResponse validateOneRequestS(List<StreamRequest> filesToValidate, boolean pdfReport, String userOrganization, String userName, String language, String pdfReportName, boolean doLogs) throws NoSuchAlgorithmException, IOException, IllegalArgumentException {
        return this.validateOneRequestS(filesToValidate, pdfReport, userOrganization, userName, language, pdfReportName, doLogs, false);
    }

    public ValidationResponse validateOneRequestS(List<StreamRequest> filesToValidate, boolean pdfReport, String userOrganization, String userName, String language, String pdfReportName, boolean doLogs, boolean processUnsignedFiles) throws NoSuchAlgorithmException, IOException, IllegalArgumentException {
        this.checkLicense();
        ServiceInput request = new ServiceInputBuilder().addStreamRequests(filesToValidate).userName(userName).userOrganization(userOrganization).language(language).pdfReport(pdfReport).pdfReportName(pdfReportName).processUnsignedFiles(processUnsignedFiles).build();
        return this.invokeTarget(API_PATH, request, doLogs);
    }

    public ValidationResponse validateOneSignature(byte[] fileToValidate, String client, boolean pdfReport, String sigName, String docName, String userOrganization, String userName, String language, String pdfReportName) throws NoSuchAlgorithmException, IOException {
        return this.validateOneSignature(fileToValidate, client, pdfReport, sigName, docName, userOrganization, userName, language, pdfReportName, false);
    }

    public ValidationResponse validateOneSignature(byte[] fileToValidate, String client, boolean pdfReport, String sigName, String docName, String userOrganization, String userName, String language, String pdfReportName, boolean doLogs) throws NoSuchAlgorithmException, IOException {
        ServiceInput request;
        this.checkLicense();
        try {
            request = new ServiceInputBuilder().addDocumentBytes(fileToValidate, docName, client).userName(userName).userOrganization(userOrganization).language(language).pdfReport(pdfReport).pdfReportName(pdfReportName).fieldName(sigName).build();
        }
        catch (IllegalArgumentException ex) {
            ValidationResponse response = new ValidationResponse();
            response.setError(ex.getMessage());
            return response;
        }
        return this.invokeTarget(API_PATH, request, doLogs);
    }

    public ValidationResponse validatePkcs7(CMSSignedData pkcs7, byte[] plainHash, String client) throws IOException {
        return this.validatePkcs7(pkcs7, plainHash, client, false);
    }

    public ValidationResponse validatePkcs7(CMSSignedData pkcs7, byte[] plainHash, String client, boolean doLogs) throws IOException {
        ServiceInput request;
        this.checkLicense();
        try {
            request = new ServiceInputBuilder().addCmsBytes(pkcs7, plainHash, client).build();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new UnreachableCodeError();
        }
        return this.invokeTarget(API_PATH, request, doLogs);
    }

    static {
        Log = LoggerFactory.getLogger(EGovValidationServiceClient.class);
        LICENSE_PRODUCT = LicenseTools.createProduct(EGovValidationServiceClient.class, (String)PRODUCT_ID, (String)PACKAGE.ImplementationVersion, (boolean)false);
    }
}

