/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.standard.validation.ocsp;

import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.standard.validation.CertificateID;
import de.intarsys.security.standard.validation.ocsp.IOCSPCache;
import de.intarsys.security.standard.validation.ocsp.OCSPCacheKey;
import de.intarsys.security.standard.validation.ocsp.StandardOCSPCacheEntry;
import de.intarsys.tools.component.CommonStartStop;
import de.intarsys.tools.component.IStartStop;
import de.intarsys.tools.date.DateEnvironment;
import de.intarsys.tools.date.IDateEnvironment;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;

public class StandardOCSPCache
implements IOCSPCache,
IStartStop {
    private SoftReference<Map<OCSPCacheKey, StandardOCSPCacheEntry>> entries;
    private long maxCachingTime = -1L;
    private long cleanUpDelay = 60000L;
    private ScheduledExecutorService executor = Executors.newScheduledThreadPool(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable pR) {
            Thread t = new Thread(pR, "TimeServer update thread");
            t.setDaemon(true);
            return t;
        }
    });
    private final IStartStop lifecycleHandler = new CommonStartStop(){

        protected void basicStart() {
            StandardOCSPCache.this.basicStart();
        }

        protected void basicStop() {
            StandardOCSPCache.this.basicStop();
        }

        public boolean stopRequested(Set visited) {
            return StandardOCSPCache.this.basicStopRequested(visited);
        }
    };
    private Runnable cleanUpCommand = new Runnable(){

        @Override
        public void run() {
            StandardOCSPCache.this.cleanUp();
        }
    };
    private IDateEnvironment dateEnvironment;

    protected StandardOCSPCacheEntry basicLookupEntry(OCSPCacheKey key) {
        return this.getEntries().get(key);
    }

    protected void basicRemoveEntry(OCSPCacheKey key) {
        this.getEntries().remove(key);
    }

    protected void basicSetEntry(OCSPCacheKey key, StandardOCSPCacheEntry entry) {
        this.getEntries().put(key, entry);
    }

    protected void basicStart() {
        this.dateEnvironment = DateEnvironment.get();
        this.executor.scheduleWithFixedDelay(this.cleanUpCommand, this.getCleanUpDelay(), this.getCleanUpDelay(), TimeUnit.MILLISECONDS);
    }

    protected void basicStop() {
        this.executor.shutdownNow();
    }

    protected boolean basicStopRequested(Set visited) {
        return true;
    }

    @Override
    public void cacheResponse(IX509Certificate certificate, IX509PublicKeyCertificate issuerCertificate, String url, BasicOCSPResp response) {
        if (this.getMaxCachingTime() == 0L) {
            return;
        }
        OCSPCacheKey key = this.createKey(certificate, issuerCertificate, url);
        StandardOCSPCacheEntry oldEntry = this.basicLookupEntry(key);
        if (oldEntry == null || response.getProducedAt().after(oldEntry.getProducedAt())) {
            StandardOCSPCacheEntry entry = new StandardOCSPCacheEntry();
            entry.setResponseObject(response);
            this.basicSetEntry(key, entry);
        }
    }

    protected void cleanUp() {
        Map<OCSPCacheKey, StandardOCSPCacheEntry> entries = this.getEntries();
        ArrayList<OCSPCacheKey> outdated = new ArrayList<OCSPCacheKey>();
        for (Map.Entry<OCSPCacheKey, StandardOCSPCacheEntry> mapEntry : new ArrayList<Map.Entry<OCSPCacheKey, StandardOCSPCacheEntry>>(entries.entrySet())) {
            long cachingTime;
            StandardOCSPCacheEntry entry = mapEntry.getValue();
            if (this.getMaxCachingTime() <= -1L || (cachingTime = this.dateEnvironment.now().getTime() - entry.getCreationTime().getTime()) <= this.getMaxCachingTime()) continue;
            outdated.add(mapEntry.getKey());
        }
        for (OCSPCacheKey entry : outdated) {
            entries.remove(entry);
        }
    }

    @Override
    public void clear() {
        this.entries = null;
    }

    protected OCSPCacheKey createKey(IX509Certificate certificate, IX509PublicKeyCertificate issuerCertificate, String url) {
        OCSPCacheKey key = new OCSPCacheKey();
        key.setCertificate(CertificateID.create(certificate));
        key.setIssuerCertificate(CertificateID.create(issuerCertificate));
        key.setUrl(url);
        return key;
    }

    public long getCleanUpDelay() {
        return this.cleanUpDelay;
    }

    protected Map<OCSPCacheKey, StandardOCSPCacheEntry> getEntries() {
        Map<OCSPCacheKey, StandardOCSPCacheEntry> result = null;
        if (this.entries != null) {
            result = this.entries.get();
        }
        if (result == null) {
            result = new HashMap<OCSPCacheKey, StandardOCSPCacheEntry>();
            this.entries = new SoftReference<Map<OCSPCacheKey, StandardOCSPCacheEntry>>(result);
        }
        return result;
    }

    public long getMaxCachingTime() {
        return this.maxCachingTime;
    }

    @Override
    public int getSize() {
        return this.getEntries().size();
    }

    public boolean isStarted() {
        return this.lifecycleHandler.isStarted();
    }

    @Override
    public BasicOCSPResp lookupResponse(IX509Certificate certificate, IX509PublicKeyCertificate issuerCertificate, String url) {
        OCSPCacheKey key = this.createKey(certificate, issuerCertificate, url);
        StandardOCSPCacheEntry entry = this.basicLookupEntry(key);
        if (entry == null) {
            return null;
        }
        return entry.getResponseObject();
    }

    @Override
    public BasicOCSPResp lookupResponse(IX509Certificate certificate, IX509PublicKeyCertificate issuerCertificate, String url, Date notOlderThan) {
        OCSPCacheKey key = this.createKey(certificate, issuerCertificate, url);
        StandardOCSPCacheEntry entry = this.basicLookupEntry(key);
        if (entry == null) {
            return null;
        }
        if (notOlderThan != null && notOlderThan.after(entry.getProducedAt())) {
            return null;
        }
        return entry.getResponseObject();
    }

    public void setCleanUpDelay(long cleanUpDelay) {
        this.cleanUpDelay = cleanUpDelay;
    }

    public void setMaxCachingTime(long maxCachingTime) {
        this.maxCachingTime = maxCachingTime;
    }

    public void start() {
        this.lifecycleHandler.start();
    }

    public void stop() {
        this.lifecycleHandler.stop();
    }

    public boolean stopRequested(Set visited) {
        return this.lifecycleHandler.stopRequested(visited);
    }
}

