/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.standard.validation;

import de.intarsys.security.standard.validation.CommonValidationState;
import de.intarsys.security.standard.validation.PACKAGE;
import de.intarsys.security.standard.validation.VSCertificate;
import de.intarsys.security.validation.IOrigin;
import de.intarsys.security.validation.IVSCertificate;
import de.intarsys.security.validation.IVSRevocationRequest;
import de.intarsys.security.validation.IVSSignature;
import de.intarsys.security.validation.IVTCertificate;
import de.intarsys.security.validation.IValidationTarget;
import de.intarsys.security.validation.Origin;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.string.PrettyPrinter;
import java.util.Date;

public abstract class VSRevocationRequest
extends CommonValidationState
implements IVSRevocationRequest {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private IVSCertificate certificateState;
    private IVSSignature signatureState;
    private Date revocationDate;
    private int revocationReason;
    private String revocationState;
    private IOrigin origin;

    protected VSRevocationRequest(IValidationTarget target) {
        super(target);
    }

    protected VSRevocationRequest(IValidationTarget target, int state) {
        super(target, state);
    }

    protected boolean basicIsRecoverable() {
        return true;
    }

    @Override
    public IVSCertificate getCertificateState() {
        if (this.certificateState == null) {
            this.certificateState = new VSCertificate((IVTCertificate)null);
        }
        return this.certificateState;
    }

    @Override
    public IOrigin getOrigin() {
        if (this.origin == null) {
            this.origin = Origin.undefined();
        }
        return this.origin;
    }

    @Override
    public Date getRevocationDate() {
        return this.revocationDate;
    }

    @Override
    public int getRevocationReason() {
        return this.revocationReason;
    }

    @Override
    public String getRevocationReasonAsString() {
        return Msg.getString("RevocationRequestState.Reason_" + this.getRevocationReason(), new Object[0]);
    }

    @Override
    public String getRevocationState() {
        return this.revocationState;
    }

    @Override
    public IVSSignature getSignatureState() {
        return this.signatureState;
    }

    @Override
    public boolean isRecoverable() {
        if (!this.isUnknown()) {
            return false;
        }
        if (!this.isRecoverable(this.getSignatureState())) {
            return false;
        }
        if (!this.isRecoverable(this.getCertificateState())) {
            return false;
        }
        return this.basicIsRecoverable();
    }

    public void setCertificateState(IVSCertificate certificateState) {
        this.certificateState = certificateState;
        this.increaseState(certificateState);
    }

    public void setOrigin(IOrigin origin) {
        this.origin = origin;
    }

    public void setRevocationDate(Date revocationDate) {
        this.revocationDate = revocationDate;
    }

    public void setRevocationReason(int revocationReason) {
        this.revocationReason = revocationReason;
    }

    public void setRevocationState(String revocationState) {
        this.revocationState = revocationState;
    }

    public void setSignatureState(IVSSignature signatureState) {
        this.signatureState = signatureState;
        this.increaseState(signatureState);
    }

    @Override
    public void toString(PrettyPrinter printer) {
        super.toString(printer);
        printer.appendMember("origin", (Object)this.getOrigin(), null);
        printer.appendMember("revocationDate", (Object)this.getRevocationDate(), null);
        printer.appendMember("revocationReason", (Object)this.getRevocationReasonAsString(), null);
        printer.appendMember("revocationState", (Object)this.getRevocationState(), null);
        printer.appendMember("certificateState", (Object)this.getCertificateState(), null);
        printer.appendMember("signatureState", (Object)this.getSignatureState(), null);
    }
}

