/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.standard.validation;

import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509CertificatePath;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.isismtt.ISISMTTObjectIdentifiers;
import org.bouncycastle.asn1.x509.qualified.QCStatement;

public class QCTools {
    private static final String QC_STATEMENTS = "1.3.6.1.5.5.7.1.3";
    private static final Set<String> BNETZA_PRINCIPALS = new HashSet<String>();

    public static boolean hasETSIQCComplianceStatement(IX509Certificate certificate) throws IOException {
        ASN1Sequence derQCStatements = (ASN1Sequence)CertificateTools.getExtensionValue(certificate, QC_STATEMENTS);
        if (derQCStatements != null) {
            Enumeration e = derQCStatements.getObjects();
            while (e.hasMoreElements()) {
                ASN1Encodable derQCStatement = (ASN1Encodable)e.nextElement();
                QCStatement statement = QCStatement.getInstance((Object)derQCStatement);
                if (!QCStatement.id_etsi_qcs_QcCompliance.equals((ASN1Primitive)statement.getStatementId())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasISISMTTAccreditedAccreditedPolicy(IX509Certificate certificate) throws IOException {
        return CertificateTools.hasPolicy(certificate, ISISMTTObjectIdentifiers.id_isismtt_cp_accredited);
    }

    public static boolean isBNETZACertificate(IX509Certificate certificate) {
        String name;
        X500Principal subject = certificate.getSubjectX500Principal();
        return subject != null && BNETZA_PRINCIPALS.contains(name = subject.getName("RFC1779"));
    }

    public static boolean isBNETZAIssued(IX509Certificate certificate) {
        String name;
        String name2;
        X500Principal subject = certificate.getSubjectX500Principal();
        if (subject != null && BNETZA_PRINCIPALS.contains(name2 = subject.getName("RFC1779"))) {
            return true;
        }
        X500Principal issuer = certificate.getIssuerX500Principal();
        return issuer != null && BNETZA_PRINCIPALS.contains(name = issuer.getName("RFC1779"));
    }

    public static boolean isBNETZAIssued(IX509CertificatePath path) {
        if (path == null || path.size() == 0) {
            return false;
        }
        for (IX509Certificate currentCertificate : path.getPath()) {
            if (!QCTools.isBNETZAIssued(currentCertificate)) continue;
            return true;
        }
        return false;
    }

    public static boolean isQualificationPostulated(IX509Certificate certificate) throws IOException {
        return QCTools.hasETSIQCComplianceStatement(certificate) || QCTools.hasISISMTTAccreditedAccreditedPolicy(certificate);
    }

    public static boolean isQualificationPostulated(IX509CertificatePath path) throws IOException {
        if (path == null || path.size() == 0) {
            return false;
        }
        for (IX509Certificate currentCertificate : path.getPath()) {
            if (!QCTools.isQualificationPostulated(currentCertificate)) continue;
            return true;
        }
        return false;
    }

    static {
        BNETZA_PRINCIPALS.add("OID.0.2.262.1.10.7.20=1 + CN=3R-CA 1:PN, O=Regulierungsbeh\u00c8orde f\u00c8ur Telekommunikation und Post, C=DE");
        BNETZA_PRINCIPALS.add("OID.0.2.262.1.10.7.20=1 + CN=4R-CA 1:PN, O=Regulierungsbeh\u00c8orde f\u00c8ur Telekommunikation und Post, C=DE");
        BNETZA_PRINCIPALS.add("OID.0.2.262.1.10.7.20=1 + CN=5R-CA 1:PN, O=Regulierungsbeh\u00c8orde f\u00c8ur Telekommunikation und Post, C=DE");
        BNETZA_PRINCIPALS.add("OID.0.2.262.1.10.7.20=1 + CN=6R-Ca 1:PN, O=Regulierungsbeh\u00c8orde f\u00c8ur Telekommunikation und Post, C=DE");
        BNETZA_PRINCIPALS.add("OID.0.2.262.1.10.7.20=1 + CN=7R-CA 1:PN, O=Regulierungsbeh\u00c8orde f\u00c8ur Telekommunikation und Post, C=DE");
        BNETZA_PRINCIPALS.add("CN=8R-CA 1:PN, O=Regulierungsbeh\u00f6rde f\u00fcr Telekommunikation und Post, C=DE");
        BNETZA_PRINCIPALS.add("CN=9R-CA 1:PN, O=Regulierungsbeh\u00f6rde f\u00fcr Telekommunikation und Post, C=DE");
        BNETZA_PRINCIPALS.add("CN=10R-CA 1:PN, O=Bundesnetzagentur, C=DE");
        BNETZA_PRINCIPALS.add("CN=11R-CA 1:PN, O=Bundesnetzagentur, C=DE");
    }
}

