/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.standard.validation;

import de.intarsys.security.standard.validation.PACKAGE;
import de.intarsys.security.standard.validation.ValidationMessage;
import de.intarsys.security.validation.IValidationMessage;
import de.intarsys.tools.message.IMessageBundle;

public class CommonValidationMessages {
    private static final IMessageBundle Msg = PACKAGE.Messages;

    public static IValidationMessage ERROR_ALGORITHM_UNKNOWN(Exception e, String algorithm) {
        return ValidationMessage.createError(Msg.getString("CommonValidationMessages.ErrorAlgorithmUnknown", new Object[]{algorithm}));
    }

    public static IValidationMessage ERROR_CERTIFICATE(Exception e) {
        return ValidationMessage.createError(Msg.getString("CommonValidationMessages.ErrorCertificate", new Object[0]));
    }

    public static IValidationMessage ERROR_CERTIFICATE_NOT_AVAILABLE() {
        return ValidationMessage.createError(Msg.getString("CommonValidationMessages.ErrorCertificateNotAvailable", new Object[0]));
    }

    public static IValidationMessage ERROR_CERTIFICATE_PATH_DOES_NOT_CHAIN() {
        return ValidationMessage.createError(Msg.getString("CommonValidationMessages.ErrorCertificatePathDoesNotChain", new Object[0]));
    }

    public static IValidationMessage ERROR_CERTIFICATE_PATH_UNTRUSTED_ROOT() {
        return ValidationMessage.createError(Msg.getString("CommonValidationMessages.ErrorCertificatePathUntrustedRoot", new Object[0]));
    }

    public static IValidationMessage ERROR_DATA_BAD(String data) {
        return ValidationMessage.createError(Msg.getString("CommonValidationMessages.ErrorDataBad", new Object[0]));
    }

    public static IValidationMessage ERROR_DATA_MISSING(String data) {
        return ValidationMessage.createError(Msg.getString("CommonValidationMessages.ErrorDataMissing", new Object[0]));
    }

    public static IValidationMessage ERROR_DATA_SCOPE_BIGGER() {
        return ValidationMessage.createError(Msg.getString("CommonValidationMessages.ErrorDataScopeBigger", new Object[0]));
    }

    public static IValidationMessage ERROR_DATA_SCOPE_ERROR_INTERNAL(Exception e) {
        return ValidationMessage.createError(Msg.getString("CommonValidationMessages.ErrorDataScopeErrorInternal", new Object[0]));
    }

    public static IValidationMessage ERROR_DATA_SCOPE_SMALLER() {
        return ValidationMessage.createWarning(Msg.getString("CommonValidationMessages.ErrorDataScopeSmaller", new Object[0]));
    }

    public static IValidationMessage ERROR_DIGEST_VERIFIED_FALSE() {
        return ValidationMessage.createError(Msg.getString("CommonValidationMessages.ErrorDigestVerifiedFalse", new Object[0]));
    }

    public static IValidationMessage ERROR_EXTENSION_NOT_CRITICAL(String extension) {
        return ValidationMessage.createError(Msg.getString("CommonValidationMessages.ErrorExtensionNotCritical", new Object[]{extension}));
    }

    public static IValidationMessage ERROR_ILLEGAL_BLOCK_SIZE(Exception e) {
        return ValidationMessage.createError(Msg.getString("CommonValidationMessages.ErrorIllegalBlockSize", new Object[0]));
    }

    public static IValidationMessage ERROR_IO(Exception e) {
        return ValidationMessage.createError(Msg.getString("CommonValidationMessages.ErrorIO", new Object[0]));
    }

    public static IValidationMessage ERROR_IO_EXTENSION(Exception e, String extension) {
        return ValidationMessage.createError(Msg.getString("CommonValidationMessages.ErrorIOExtension", new Object[]{extension, e.getLocalizedMessage()}));
    }

    public static IValidationMessage ERROR_KEY(Exception e) {
        return ValidationMessage.createError(Msg.getString("CommonValidationMessages.ErrorKey", new Object[0]));
    }

    public static IValidationMessage ERROR_MISSING_EXTENSION(String extension) {
        return ValidationMessage.createError(Msg.getString("CommonValidationMessages.ErrorMissingExtension", new Object[]{extension}));
    }

    public static IValidationMessage ERROR_PADDING_BAD(Exception e) {
        return ValidationMessage.createError(Msg.getString("CommonValidationMessages.ErrorPaddingBad", new Object[0]));
    }

    public static IValidationMessage ERROR_PADDING_UNKNOWN(Exception e, String padding) {
        return ValidationMessage.createError(Msg.getString("CommonValidationMessages.ErrorPaddingUnknown", new Object[0]));
    }

    public static IValidationMessage ERROR_SIGNATURE(Exception e) {
        return ValidationMessage.createError(Msg.getString("CommonValidationMessages.ErrorSignature", new Object[0]));
    }

    public static IValidationMessage ERROR_SIGNATURE_VERIFIED_FALSE() {
        return ValidationMessage.createError(Msg.getString("CommonValidationMessages.ErrorSignatureVerifiedFalse", new Object[0]));
    }

    public static IValidationMessage ERROR_UNPROCESSED_CRITICAL_EXTENSION(String extension) {
        return ValidationMessage.createError(Msg.getString("CommonValidationMessages.ErrorUnprocessedCriticalExtension", new Object[]{extension}));
    }

    public static IValidationMessage ERROR_VERIFIED_FALSE() {
        return ValidationMessage.createError(Msg.getString("CommonValidationMessages.ErrorVerifiedFalse", new Object[0]));
    }

    protected static String getErrorMessage(Exception e) {
        if (e == null) {
            return "";
        }
        return e.getLocalizedMessage();
    }

    public static IValidationMessage INFO_CERTIFICATE_PATH_TRUSTED() {
        return ValidationMessage.createInfo(Msg.getString("CommonValidationMessages.InfoCertificatePathTrusted", new Object[0]));
    }

    public static IValidationMessage INFO_CERTIFICATE_SELF_SIGNED_TRUSTED() {
        return ValidationMessage.createInfo(Msg.getString("CommonValidationMessages.InfoCertificateSelfSignedTrusted", new Object[0]));
    }

    public static IValidationMessage INFO_DATA_SCOPE_EXACT() {
        return ValidationMessage.createInfo(Msg.getString("CommonValidationMessages.InfoDataScopeExact", new Object[0]));
    }

    public static IValidationMessage INFO_DATA_UNCHANGED() {
        return ValidationMessage.createInfo(Msg.getString("CommonValidationMessages.InfoDataUnchanged", new Object[0]));
    }

    public static IValidationMessage INFO_DIGEST_VERIFIED_TRUE() {
        return ValidationMessage.createInfo(Msg.getString("CommonValidationMessages.InfoDigestVerifiedTrue", new Object[0]));
    }

    public static IValidationMessage INFO_SIGNATURE_VERIFIED_TRUE() {
        return ValidationMessage.createInfo(Msg.getString("CommonValidationMessages.InfoSignatureVerifiedTrue", new Object[0]));
    }

    public static IValidationMessage INFO_VERIFIED_TRUE() {
        return ValidationMessage.createInfo(Msg.getString("CommonValidationMessages.InfoVerifiedTrue", new Object[0]));
    }

    public static IValidationMessage WARNING_DATA_INCREMENTALLY_CHANGED() {
        return ValidationMessage.createWarning(Msg.getString("CommonValidationMessages.WarningDataIncrementallyChanged", new Object[0]));
    }

    public static IValidationMessage WARNING_MISSING_EXTENSION(String extension) {
        return ValidationMessage.createWarning(Msg.getString("CommonValidationMessages.ErrorMissingExtension", new Object[]{extension}));
    }
}

