/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.standard.validation;

import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509CertificateReference;
import de.intarsys.tools.string.StringTools;
import java.math.BigInteger;
import java.util.Arrays;
import javax.security.auth.x500.X500Principal;

public class CertificateID
implements IX509CertificateReference {
    private boolean[] issuerUniqueID;
    private X500Principal issuerX500Principal;
    private BigInteger serialNumber;
    private X500Principal subjectX500Principal;

    public static CertificateID create(IX509Certificate certificate) {
        CertificateID certificateID = new CertificateID();
        certificateID.setSubjectX500Principal(certificate.getSubjectX500Principal());
        certificateID.setIssuerX500Principal(certificate.getIssuerX500Principal());
        certificateID.setSerialNumber(certificate.getSerialNumber());
        certificateID.setIssuerUniqueID(certificate.getIssuerUniqueID());
        return certificateID;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CertificateID)) {
            return false;
        }
        CertificateID other = (CertificateID)obj;
        if (this.getSerialNumber() == null ? other.getSerialNumber() != null : !this.getSerialNumber().equals(other.getSerialNumber())) {
            return false;
        }
        if (this.getSubjectX500Principal() == null ? other.getSubjectX500Principal() != null : !this.getSubjectX500Principal().equals(other.getSubjectX500Principal())) {
            return false;
        }
        if (this.getIssuerX500Principal() == null ? other.getIssuerX500Principal() != null : !this.getIssuerX500Principal().equals(other.getIssuerX500Principal())) {
            return false;
        }
        return !(this.getIssuerUniqueID() == null ? other.getIssuerUniqueID() != null : !Arrays.equals(this.getIssuerUniqueID(), other.getIssuerUniqueID()));
    }

    @Override
    public boolean[] getIssuerUniqueID() {
        return this.issuerUniqueID;
    }

    @Override
    public X500Principal getIssuerX500Principal() {
        return this.issuerX500Principal;
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    @Override
    public X500Principal getSubjectX500Principal() {
        return this.subjectX500Principal;
    }

    public int hashCode() {
        StringBuilder sb = new StringBuilder();
        if (this.getSubjectX500Principal() != null) {
            sb.append(this.getSubjectX500Principal().hashCode());
        }
        sb.append("/");
        if (this.getSerialNumber() != null) {
            sb.append(this.getSerialNumber().hashCode());
        }
        sb.append("/");
        if (this.getIssuerX500Principal() != null) {
            sb.append(this.getIssuerX500Principal().hashCode());
        }
        sb.append("/");
        if (this.getIssuerUniqueID() != null) {
            sb.append(Arrays.hashCode(this.getIssuerUniqueID()));
        }
        return sb.toString().hashCode();
    }

    public void setIssuerUniqueID(boolean[] issuerUniqueID) {
        this.issuerUniqueID = issuerUniqueID;
    }

    public void setIssuerX500Principal(X500Principal issuerX500Principal) {
        this.issuerX500Principal = issuerX500Principal;
    }

    public void setSerialNumber(BigInteger serialNumber) {
        this.serialNumber = serialNumber;
    }

    public void setSubjectX500Principal(X500Principal subjectX500Principal) {
        this.subjectX500Principal = subjectX500Principal;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Subject: ").append(this.getSubjectX500Principal()).append(StringTools.LS);
        sb.append("Serial Number: ").append(this.getSerialNumber()).append(StringTools.LS);
        sb.append("Issuer: ").append(this.getIssuerX500Principal()).append(StringTools.LS);
        sb.append("Issuer Unique ID: ").append(Arrays.toString(this.getIssuerUniqueID())).append(StringTools.LS);
        return sb.toString();
    }
}

