/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.signature.policy.asn1;

import de.intarsys.asn1.policy.CommitmentRule;
import de.intarsys.asn1.policy.SignPolExtensions;
import de.intarsys.asn1.policy.SignatureValidationPolicy;
import de.intarsys.security.signature.policy.EmptyExtensions;
import de.intarsys.security.signature.policy.ICommitmentRule;
import de.intarsys.security.signature.policy.ICommonRules;
import de.intarsys.security.signature.policy.IExtension;
import de.intarsys.security.signature.policy.IExtensionSupport;
import de.intarsys.security.signature.policy.ISignatureValidationPolicy;
import de.intarsys.security.signature.policy.asn1.ASN1CommitmentRule;
import de.intarsys.security.signature.policy.asn1.ASN1CommonRules;
import de.intarsys.security.signature.policy.asn1.ASN1Extensions;
import java.util.Date;

public class ASN1SignatureValidationPolicy
implements ISignatureValidationPolicy {
    private SignatureValidationPolicy impl;
    private IExtensionSupport extensionSupport;
    private ASN1CommonRules commonRules;
    private ICommitmentRule[] commitmentRules;

    public ASN1SignatureValidationPolicy(SignatureValidationPolicy impl) {
        this.impl = impl;
        this.commonRules = new ASN1CommonRules(impl.getCommonRules());
        CommitmentRule[] commitmentRules = impl.getCommitmentRules();
        this.commitmentRules = new ICommitmentRule[commitmentRules.length];
        for (int i = 0; i < commitmentRules.length; ++i) {
            this.commitmentRules[i] = new ASN1CommitmentRule(commitmentRules[i]);
        }
        SignPolExtensions signPolExtensions = impl.getSignPolExtensions();
        this.extensionSupport = signPolExtensions == null ? new EmptyExtensions() : new ASN1Extensions(signPolExtensions);
    }

    @Override
    public Date getNotBefore() {
        return this.impl.getSigningPeriod().getNotBefore();
    }

    @Override
    public Date getNotAfter() {
        return this.impl.getSigningPeriod().getNotAfter();
    }

    @Override
    public ICommonRules getCommonRules() {
        return this.commonRules;
    }

    @Override
    public ICommitmentRule[] getCommitmentRules() {
        return this.commitmentRules;
    }

    @Override
    public IExtension getExtension(String oid) {
        return this.getExtensionSupport().getExtension(oid);
    }

    @Override
    public IExtension[] getExtensions() {
        return this.getExtensionSupport().getExtensions();
    }

    protected IExtensionSupport getExtensionSupport() {
        return this.extensionSupport;
    }
}

