/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.signature.policy;

import de.intarsys.security.app.validation.IReviewer;
import de.intarsys.security.app.validation.IValidationParameters;
import de.intarsys.security.signature.ISignatureEntry;
import de.intarsys.security.signature.policy.ASN1SignaturePolicyValidator;
import de.intarsys.security.signature.policy.IPolicy;
import de.intarsys.security.signature.policy.IPolicyId;
import de.intarsys.security.signature.policy.IPolicyReference;
import de.intarsys.security.signature.policy.PolicyTools;
import de.intarsys.security.signature.policy.asn1.ASN1SignaturePolicy;
import de.intarsys.security.standard.validation.VSSignatureEntry;
import de.intarsys.security.validation.IVSSignatureEntry;

public class SignaturePolicyValidator {
    public static IReviewer<ISignatureEntry, IVSSignatureEntry> create(IPolicy policy) {
        if (policy instanceof ASN1SignaturePolicy) {
            return new ASN1SignaturePolicyValidator((ASN1SignaturePolicy)policy);
        }
        return new IReviewer<ISignatureEntry, IVSSignatureEntry>(){

            @Override
            public IVSSignatureEntry review(ISignatureEntry signatureEntry, IVSSignatureEntry state, IValidationParameters params) {
                if (state != null) {
                    return state;
                }
                return new VSSignatureEntry(signatureEntry, -1);
            }
        };
    }

    public static IReviewer<ISignatureEntry, IVSSignatureEntry> create(IPolicyReference policyReference) {
        IPolicy policy = null;
        if (policyReference instanceof IPolicyId) {
            policy = PolicyTools.lookupPolicy((IPolicyId)policyReference);
        }
        return SignaturePolicyValidator.create(policy);
    }
}

