/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.signature.common;

import de.intarsys.security.signature.common.IToBeSignedData;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import java.io.IOException;

public class ToBeSignedData
implements IToBeSignedData {
    private final byte[] encodedDigest;
    private final IDigest digest;

    public static ToBeSignedData create(byte[] encodedDigest) throws IOException {
        return new ToBeSignedData(encodedDigest);
    }

    public static ToBeSignedData create(IDigest digest) throws IOException {
        return new ToBeSignedData(digest);
    }

    protected ToBeSignedData(byte[] encodedDigest) throws IOException {
        this.encodedDigest = encodedDigest;
        this.digest = DigestTools.createDigest((byte[])encodedDigest);
    }

    protected ToBeSignedData(IDigest digest) throws IOException {
        this.encodedDigest = digest.getEncoded();
        this.digest = digest;
    }

    public IDigest getDigest() {
        return this.digest;
    }

    @Override
    public byte[] getEncodedDigest() {
        return this.encodedDigest;
    }

    public String toString() {
        return String.format("%s(digest=%s)", this.getClass().getSimpleName(), this.digest);
    }
}

