/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.signature;

import de.intarsys.security.signature.RevocationInfoDepth;
import de.intarsys.security.signature.RevocationInfoType;

public class ValidationDataOptions {
    public static final ValidationDataOptions NONE = new ValidationDataOptions(RevocationInfoDepth.NONE, RevocationInfoType.ANY);
    public static final ValidationDataOptions SIGNER = new ValidationDataOptions(RevocationInfoDepth.SIGNER, RevocationInfoType.ANY);
    public static final ValidationDataOptions ALL = new ValidationDataOptions(RevocationInfoDepth.ALL, RevocationInfoType.ANY);
    private final RevocationInfoDepth revocationInfoDepth;
    private final RevocationInfoType revocationInfoType;

    public ValidationDataOptions(RevocationInfoDepth revocationInfoDepth, RevocationInfoType revocationInfoType) {
        if (revocationInfoDepth == null) {
            throw new IllegalArgumentException("'revocationInfoDepth' cannot be null");
        }
        if (revocationInfoType == null) {
            throw new IllegalArgumentException("'revocationInfoType' cannot be null");
        }
        this.revocationInfoDepth = revocationInfoDepth;
        this.revocationInfoType = revocationInfoType;
    }

    public RevocationInfoDepth getRevocationInfoDepth() {
        return this.revocationInfoDepth;
    }

    public RevocationInfoType getRevocationInfoType() {
        return this.revocationInfoType;
    }

    public boolean isAddRevocationInfoDepthAll() {
        return this.revocationInfoDepth == RevocationInfoDepth.ALL;
    }

    public boolean isAddRevocationInfoDepthSigner() {
        return this.revocationInfoDepth == RevocationInfoDepth.SIGNER;
    }

    public boolean isAddRevocationInfoTypeCrl() {
        return this.revocationInfoType.isCrl();
    }

    public boolean isAddRevocationInfoTypeOcsp() {
        return this.revocationInfoType.isOcsp();
    }

    public boolean isAddValidationData() {
        return this.revocationInfoDepth != RevocationInfoDepth.NONE;
    }
}

