/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.ocsp.common;

import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.ocsp.IOCSPSingleResult;
import de.intarsys.tools.exception.ExceptionTools;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.Set;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.RevokedStatus;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.cert.ocsp.UnknownStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleResult
implements IOCSPSingleResult {
    private static final Logger Log = LoggerFactory.getLogger(SingleResult.class);
    private final SingleResp impl;
    private IX509Certificate certificate;

    public SingleResult(SingleResp impl) {
        this.impl = impl;
    }

    public SingleResult(SingleResp impl, IX509Certificate certificate) {
        this.impl = impl;
        this.certificate = certificate;
    }

    @Override
    public Date getArchiveCutoff() {
        try {
            ASN1Primitive derCutoff = CertificateTools.getExtensionValue(this, "1.3.6.1.5.5.7.48.1.6");
            ASN1GeneralizedTime cutoff = ASN1GeneralizedTime.getInstance((Object)derCutoff);
            if (cutoff == null) {
                return null;
            }
            return cutoff.getDate();
        }
        catch (IOException e) {
            Log.warn(e.getMessage(), (Throwable)e);
        }
        catch (ParseException e) {
            Log.warn(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public IX509Certificate getCertificate() {
        return this.certificate;
    }

    @Override
    public Set<String> getCriticalExtensionOIDs() {
        return CertificateTools.toStringIdentifiers(this.getImpl().getCriticalExtensionOIDs());
    }

    @Override
    public byte[] getExtensionValue(String oid) {
        try {
            Extension extension = this.getImpl().getExtension(new ASN1ObjectIdentifier(oid));
            if (extension == null) {
                return null;
            }
            return extension.getExtnValue().getEncoded("DER");
        }
        catch (IOException e) {
            throw ExceptionTools.wrap((Throwable)e);
        }
    }

    public SingleResp getImpl() {
        return this.impl;
    }

    @Override
    public Date getNextUpdate() {
        return this.getImpl().getNextUpdate();
    }

    @Override
    public Set<String> getNonCriticalExtensionOIDs() {
        return CertificateTools.toStringIdentifiers(this.getImpl().getNonCriticalExtensionOIDs());
    }

    @Override
    public int getRevocationReason() {
        RevokedStatus revS;
        Object resObj = this.getStatusObject();
        if (resObj instanceof RevokedStatus && (revS = (RevokedStatus)resObj).hasRevocationReason()) {
            return revS.getRevocationReason();
        }
        return 0;
    }

    @Override
    public Date getRevocationTime() {
        Object resObj = this.getStatusObject();
        if (resObj instanceof RevokedStatus) {
            RevokedStatus revS = (RevokedStatus)resObj;
            return revS.getRevocationTime();
        }
        return null;
    }

    @Override
    public int getStatus() {
        CertificateStatus status = this.getImpl().getCertStatus();
        if (status instanceof UnknownStatus) {
            return 0;
        }
        if (status instanceof RevokedStatus) {
            return 2;
        }
        return 1;
    }

    public Object getStatusObject() {
        return this.getImpl().getCertStatus();
    }

    @Override
    public Date getThisUpdate() {
        return this.getImpl().getThisUpdate();
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        Set extns = this.getImpl().getCriticalExtensionOIDs();
        return extns != null && !extns.isEmpty();
    }
}

