/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.identity;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.creation.RSAKeyPairFactory;
import de.intarsys.security.certificate.creation.X509PublicKeyCertificateCreator;
import de.intarsys.security.certificate.creation.X509PublicKeyCertificateCreatorFactory;
import de.intarsys.security.privatekey.KeyCertificatePair;
import de.intarsys.tools.crypto.CryptoTools;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.factory.FactoryTools;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.FileLocatorFactory;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorFactory;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.string.StringTools;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Identity {
    private static final String ARG_KEY = "key";
    private static final String ARG_CERTIFICATE = "certificate";
    private static final String ARG_PERSISTENT = "persistent";
    private static final String ARG_LOCATOR_FACTORY = "locatorFactory";
    private static final String KEYSTORE_TYPE = "JKS";
    private static final String DATA_KEYSTORE = "keystore";
    private static final String DATA_ID = "id";
    private static final String DATA_PASSWORD = "password";
    private static final Logger Log = LoggerFactory.getLogger(Identity.class);
    private static ObjectMapper mapper = new ObjectMapper();
    private KeyStore keyStore;
    private ILocator locator;
    private String name;
    private Secret secret;
    private String id;
    private KeyCertificatePair entity;
    private IArgs args;
    private boolean persistent = false;
    private ILocatorFactory locatorFactory = FileLocatorFactory.DATADIR;

    public static Identity create(String name, IArgs args) throws ObjectCreationException {
        Identity identity = new Identity();
        identity.setName(name);
        identity.setArgs(args);
        identity.init();
        return identity;
    }

    protected Identity() {
    }

    protected KeyCertificatePair createEntity() throws Exception {
        IArgs certArgs = ArgTools.getArgs((IArgs)this.getArgs(), (String)ARG_CERTIFICATE, (IArgs)Args.create()).copy();
        if (!certArgs.isDefined("validTo")) {
            GregorianCalendar calValidTo = new GregorianCalendar();
            ((Calendar)calValidTo).add(1, 5);
            certArgs.put("validTo", (Object)calValidTo.getTime());
        }
        X509PublicKeyCertificateCreator creator = (X509PublicKeyCertificateCreator)FactoryTools.createInstance(X509PublicKeyCertificateCreatorFactory.class, (IArgs)certArgs);
        IArgs keyArgs = ArgTools.getArgs((IArgs)this.getArgs(), (String)ARG_KEY, (IArgs)Args.create());
        KeyPair keyPair = (KeyPair)FactoryTools.createInstance((Object)RSAKeyPairFactory.ID, (IArgs)keyArgs);
        creator.setKeyPair(keyPair);
        return creator.createEntity();
    }

    protected String createId() {
        return UUID.randomUUID().toString();
    }

    protected KeyStore createKeyStore() throws Exception {
        KeyStore keystore = KeyStore.getInstance(KEYSTORE_TYPE);
        keystore.load(null, null);
        Certificate[] certs = CertificateTools.toJavaCerts(this.getEntity().getCertificateChain());
        keystore.setKeyEntry(this.getName(), this.getEntity().getPrivateKey(), this.getSecret().getChars(), certs);
        return keystore;
    }

    protected ILocator createLocator(String locatorName) throws IOException {
        return LocatorTools.createLocator((Object)locatorName, (ILocatorFactory)this.getLocatorFactory(), null);
    }

    public IArgs getArgs() {
        if (this.args == null) {
            this.args = Args.create();
        }
        return this.args;
    }

    public KeyCertificatePair getEntity() {
        return this.entity;
    }

    public String getId() {
        return this.id;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public ILocator getLocator() {
        return this.locator;
    }

    public ILocatorFactory getLocatorFactory() {
        return this.locatorFactory;
    }

    public String getName() {
        return this.name;
    }

    public Secret getSecret() {
        return this.secret;
    }

    protected void init() throws ObjectCreationException {
        String locatorName = "." + this.getName() + ".id";
        try {
            ILocator tempLocator = this.createLocator(locatorName);
            this.setLocator(tempLocator);
            if (this.isPersistent()) {
                try {
                    this.load();
                    X509Certificate certificateImpl = (X509Certificate)this.getKeyStore().getCertificate(this.getName());
                    IX509PublicKeyCertificate certificate = CertificateTools.wrapJavaCert(certificateImpl);
                    PrivateKey key = (PrivateKey)this.getKeyStore().getKey(this.getName(), this.getSecret().getChars());
                    KeyCertificatePair pair = new KeyCertificatePair(key, certificate);
                    this.setEntity(pair);
                    Log.info("{} loaded from {}", (Object)this, (Object)this.locator.getPath());
                }
                catch (Exception e) {
                    Log.info("{} load from {} error {}", new Object[]{this, this.locator.getPath(), ExceptionTools.getMessage((Throwable)e)});
                    this.renew();
                }
            } else {
                this.renew();
            }
        }
        catch (ObjectCreationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ObjectCreationException((Throwable)e);
        }
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    protected void load() throws Exception {
        try (InputStream is = this.getLocator().getInputStream();){
            Map data = (Map)mapper.readValue(is, Map.class);
            String password = (String)data.get(DATA_PASSWORD);
            this.setSecret(StringTools.isEmpty((String)password) ? Secret.EMPTY : Secret.parse((String)password));
            this.setId((String)data.get(DATA_ID));
            String encoded = (String)data.get(DATA_KEYSTORE);
            ByteArrayInputStream kis = new ByteArrayInputStream(Base64.getDecoder().decode(encoded));
            KeyStore keystore = KeyStore.getInstance(KEYSTORE_TYPE);
            keystore.load(kis, this.getSecret().getChars());
            this.setKeyStore(keystore);
        }
    }

    public void renew() throws Exception {
        this.setSecret(Secret.create((int)16));
        this.setId(this.createId());
        this.setEntity(this.createEntity());
        this.setKeyStore(this.createKeyStore());
        if (this.isPersistent()) {
            this.store();
            Log.info("{} saved at {}", (Object)this, (Object)this.locator.getPath());
        } else {
            Log.info("{} created transient", (Object)this);
        }
    }

    public void setArgs(IArgs args) {
        this.args = args;
        this.setLocatorFactory((ILocatorFactory)ArgTools.get((IArgs)this.getArgs(), (String)ARG_LOCATOR_FACTORY, ILocatorFactory.class, () -> this.getLocatorFactory()));
        this.setPersistent(ArgTools.getBoolStrict((IArgs)this.getArgs(), (String)ARG_PERSISTENT, (boolean)this.isPersistent()));
    }

    public void setEntity(KeyCertificatePair entity) {
        this.entity = entity;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    public void setLocator(ILocator locator) {
        this.locator = locator;
    }

    public void setLocatorFactory(ILocatorFactory locatorFactory) {
        this.locatorFactory = locatorFactory;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public void setSecret(Secret secret) {
        this.secret = secret;
    }

    protected void store() throws Exception {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(DATA_PASSWORD, CryptoTools.isEmpty((Secret)this.getSecret()) ? null : this.secret.getEncoded());
        data.put(DATA_ID, this.getId());
        ByteArrayOutputStream ksStream = new ByteArrayOutputStream();
        KeyStore keystore = this.getKeyStore();
        keystore.store(ksStream, this.getSecret().getChars());
        ksStream.close();
        String encoded = Base64.getEncoder().encodeToString(ksStream.toByteArray());
        data.put(DATA_KEYSTORE, encoded);
        try (OutputStream os = this.getLocator().getOutputStream();){
            mapper.writeValue(os, data);
        }
    }

    public String toString() {
        return String.format("identity '%s'", this.getName());
    }
}

