/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.extension.common;

import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.extension.CommonX509ExtensionHandler;
import de.intarsys.security.extension.common.PACKAGE;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.security.cert.X509Extension;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralSubtree;
import org.bouncycastle.asn1.x509.NameConstraints;

public class NameConstraintsHandler
extends CommonX509ExtensionHandler {
    private static final IMessageBundle Msg = PACKAGE.Messages;

    @Override
    public String getLabel() {
        return Msg.getString("NameConstraintsHandler.Label", new Object[0]);
    }

    @Override
    public String getOID() {
        return "2.5.29.30";
    }

    @Override
    public String getStringValue(X509Extension object) throws IOException {
        ASN1Primitive derNameConstraints = CertificateTools.getExtensionValue(object, this.getOID());
        if (derNameConstraints == null) {
            return null;
        }
        NameConstraints nameConstraints = NameConstraints.getInstance((Object)derNameConstraints);
        GeneralSubtree[] permitted = nameConstraints.getPermittedSubtrees();
        GeneralSubtree[] excluded = nameConstraints.getExcludedSubtrees();
        StringBuilder sb = new StringBuilder();
        if (permitted != null) {
            sb.append("Permitted subtrees: ").append(StringTools.LS);
            this.writeSubtrees(permitted, sb);
            sb.append(StringTools.LS);
        }
        if (excluded != null) {
            sb.append("Excluded subtrees: ").append(StringTools.LS);
            this.writeSubtrees(excluded, sb);
            sb.append(StringTools.LS);
        }
        return sb.toString();
    }

    protected void writeSubtrees(GeneralSubtree[] subtrees, StringBuilder sb) {
        for (GeneralSubtree subtree : subtrees) {
            GeneralName base = subtree.getBase();
            String baseString = CertificateTools.toString(base);
            sb.append(baseString).append(StringTools.LS);
        }
    }
}

