/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.extension.common;

import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.extension.CommonX509ExtensionHandler;
import de.intarsys.security.extension.common.PACKAGE;
import de.intarsys.tools.hex.HexTools;
import de.intarsys.tools.message.IMessageBundle;
import java.io.IOException;
import java.security.cert.X509Extension;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.isismtt.ISISMTTObjectIdentifiers;

public class ICCSNHandler
extends CommonX509ExtensionHandler {
    private static final String ICCSN = ISISMTTObjectIdentifiers.id_isismtt_at_iCCSN.getId();
    private static final IMessageBundle Msg = PACKAGE.Messages;

    public static String getICCSN(X509Extension certificate) throws IOException {
        ASN1OctetString derICCSN = null;
        derICCSN = (ASN1OctetString)CertificateTools.getExtensionValue(certificate, ICCSN);
        if (derICCSN == null) {
            return null;
        }
        String iccsn = HexTools.bytesToHexString((byte[])derICCSN.getOctets());
        return iccsn;
    }

    @Override
    public String getLabel() {
        return Msg.getString("ICCSNHandler.Label", new Object[0]);
    }

    @Override
    public String getOID() {
        return ICCSN;
    }

    @Override
    public String getStringValue(X509Extension object) throws IOException {
        return ICCSNHandler.getICCSN(object);
    }
}

