/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.encoding;

import de.intarsys.security.encoding.EncodingTools;
import de.intarsys.security.encoding.IEncoding;
import java.io.IOException;

public class WellKnownEncoding
implements IEncoding {
    public static final String NAME = "WellKnown";

    @Override
    public byte[] decode(byte[] message) throws IOException {
        IEncoding delegate = EncodingTools.guessEncoding(message);
        if (delegate == null) {
            throw new IOException("unsupported encoding");
        }
        return delegate.decode(message);
    }

    @Override
    public byte[] encode(byte[] message) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean match(byte[] bytes, byte[] encoded) throws IOException {
        IEncoding delegate = EncodingTools.guessEncoding(encoded);
        if (delegate == null) {
            throw new IOException("unsupported encoding");
        }
        return delegate.match(bytes, encoded);
    }
}

