/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.digest;

import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1ParsingException;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;

public class DERDigestCodec
implements DigestTools.IDigestCodec {
    public IDigest decode(byte[] derBytes) throws IOException {
        try {
            DigestInfo digestInfo = this.decodeDigestInfo(derBytes);
            String oid = digestInfo.getAlgorithmId().getAlgorithm().getId();
            DigestAlgorithm algorithm = DigestAlgorithm.lookupAlgorithmCanonical(oid);
            String name = algorithm == null ? oid : algorithm.getName();
            byte[] bytes = digestInfo.getDigest();
            return DigestTools.createDigest((String)name, (byte[])bytes);
        }
        catch (ASN1ParsingException e) {
            throw new IOException(e.getLocalizedMessage(), e);
        }
    }

    protected DigestInfo decodeDigestInfo(byte[] derDigestInfo) throws IOException {
        ASN1Primitive object = ASN1Tools.create((byte[])derDigestInfo);
        if (object instanceof ASN1Sequence) {
            return new DigestInfo((ASN1Sequence)object);
        }
        throw new IOException("not a valid DigestInfo");
    }

    public byte[] encode(IDigest digest) throws IOException {
        String oid = DigestAlgorithm.lookupOID(digest.getAlgorithmName());
        try {
            AlgorithmIdentifier aid = new AlgorithmIdentifier(new ASN1ObjectIdentifier(oid));
            return this.encodeDigestInfo(aid, digest.getBytes());
        }
        catch (Exception e) {
            throw new IOException("invalid digest algorithm OID " + oid, e);
        }
    }

    protected byte[] encodeDigestInfo(AlgorithmIdentifier algorithmId, byte[] digest) throws IOException {
        if (algorithmId.getParameters() == null) {
            algorithmId = new AlgorithmIdentifier(algorithmId.getAlgorithm(), (ASN1Encodable)DERNull.INSTANCE);
        }
        return ASN1Tools.toByteArray((ASN1Encodable[])new ASN1Encodable[]{new DigestInfo(algorithmId, digest)});
    }
}

