/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.crl.remote;

import de.intarsys.security.crl.IRemoteAccessInfo;
import de.intarsys.security.crl.IRemoteAccessor;
import de.intarsys.security.crl.remote.RemoteAccessInfoLDAP;
import de.intarsys.security.ldap.LDAPAddress;
import de.intarsys.security.ldap.X509Directory;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;

public class RemoteAccessorLDAP
implements IRemoteAccessor {
    protected static final String CONTEXT_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";

    @Override
    public byte[] download(IRemoteAccessInfo accessInfo) throws IOException {
        RemoteAccessInfoLDAP ldapInfo = (RemoteAccessInfoLDAP)accessInfo;
        String url = ldapInfo.getUrl();
        return this.download(url);
    }

    protected byte[] download(String url) throws IOException {
        int delimiter = (url = URLDecoder.decode(url, "ISO-8859-1")).indexOf(63);
        if (delimiter > 0) {
            url = url.substring(0, url.indexOf(63));
        }
        LDAPAddress address = null;
        try {
            address = LDAPAddress.parse(url);
        }
        catch (URISyntaxException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        String baseDn = address.getBaseDN();
        address.setBaseDN(null);
        url = address.getUrl();
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", CONTEXT_FACTORY);
        env.put("java.naming.provider.url", url);
        env.put("java.naming.referral", "follow");
        env.put("com.sun.jndi.ldap.read.timeout", "5000");
        env.put("com.sun.jndi.ldap.connect.timeout", "5000");
        try {
            InitialDirContext ctx = new InitialDirContext(env);
            String[] attributeIds = new String[X509Directory.ATTR_CERTIFICATE_REVOCATION_LIST_ALL.length + X509Directory.ATTR_AUTHORITY_REVOCATION_LIST_ALL.length];
            System.arraycopy(X509Directory.ATTR_CERTIFICATE_REVOCATION_LIST_ALL, 0, attributeIds, 0, X509Directory.ATTR_CERTIFICATE_REVOCATION_LIST_ALL.length);
            System.arraycopy(X509Directory.ATTR_AUTHORITY_REVOCATION_LIST_ALL, 0, attributeIds, X509Directory.ATTR_CERTIFICATE_REVOCATION_LIST_ALL.length, X509Directory.ATTR_AUTHORITY_REVOCATION_LIST_ALL.length);
            Attributes attrs = ctx.getAttributes(baseDn, attributeIds);
            if (attrs != null) {
                for (int i = 0; i < attributeIds.length; ++i) {
                    if (Thread.currentThread().isInterrupted()) {
                        return null;
                    }
                    String attributeId = attributeIds[i];
                    Attribute attrCrl = attrs.get(attributeId);
                    if (attrCrl == null) continue;
                    NamingEnumeration<?> e = attrCrl.getAll();
                    while (e.hasMoreElements()) {
                        Object value = e.nextElement();
                        if (!(value instanceof byte[])) continue;
                        byte[] crlBytes = (byte[])value;
                        return crlBytes;
                    }
                }
            }
        }
        catch (NamingException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        return null;
    }
}

