/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.crl.common;

import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.filter.standard.X509CertificateSelector;
import de.intarsys.security.crl.ICRLProvider;
import de.intarsys.security.crl.IX509CRL;
import de.intarsys.security.crl.IX509CRLSelector;
import de.intarsys.security.crl.common.CommonX509CRL;
import de.intarsys.security.crl.common.X509CRL;
import java.io.IOException;
import java.security.cert.CRLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrlTools {
    private static final Logger Log = LoggerFactory.getLogger((String)CrlTools.class.getName());

    public static Consumer<IX509CRL> attachProvider(ICRLProvider provider) {
        return crl -> {
            if (crl instanceof CommonX509CRL) {
                ((X509CRL)crl).setCRLProvider(provider);
            }
        };
    }

    public static IX509CertificateFilter createIssuerSelector(IX509CRL crl) {
        X509CertificateSelector selector = null;
        try {
            selector = (X509CertificateSelector)CertificateTools.createAuthorityKeySelector(crl);
        }
        catch (IOException e) {
            Log.warn(e.getMessage(), (Throwable)e);
        }
        if (selector == null) {
            selector = new X509CertificateSelector();
        }
        selector.setAcceptAttributeCertificates(false);
        selector.setSubject(crl.getIssuerX500Principal());
        selector.setSubjectMatchStrict(true);
        boolean[] keyUsage = new boolean[9];
        keyUsage[6] = true;
        selector.setKeyUsage(keyUsage);
        return selector;
    }

    public static Set<X500Principal> getCertificateIssuers(IX509CRL crl) throws CRLException {
        if (crl == null) {
            return Collections.emptySet();
        }
        return crl.getCertificateIssuers();
    }

    public static IssuingDistributionPoint getIssuingDistributionPoint(IX509CRL crl) throws IOException {
        ASN1Primitive asn1issuingDistributionPoint = CertificateTools.getExtensionValue(crl, "2.5.29.28");
        return IssuingDistributionPoint.getInstance((Object)asn1issuingDistributionPoint);
    }

    public static boolean isIndirectCRL(IX509CRL crl) throws CRLException, IOException {
        IssuingDistributionPoint idp = CrlTools.getIssuingDistributionPoint(crl);
        if (idp == null) {
            return false;
        }
        return idp.isIndirectCRL();
    }

    protected static boolean matchCRL(IX509CRLSelector selector, Set<X500Principal> targetIssuers, IX509CRL crl) throws CRLException {
        boolean indirect = false;
        try {
            indirect = CrlTools.isIndirectCRL(crl);
        }
        catch (IOException e) {
            Log.warn(e.getMessage(), (Throwable)e);
        }
        Set<X500Principal> issuers = null;
        if (indirect) {
            issuers = crl.getCertificateIssuers();
        } else {
            issuers = new HashSet<X500Principal>();
            issuers.add(crl.getIssuerX500Principal());
        }
        return CrlTools.matchCRL(selector, issuers, crl, targetIssuers);
    }

    protected static boolean matchCRL(IX509CRLSelector selector, Set<X500Principal> issuers, IX509CRL crl, Set<X500Principal> targetIssuers) {
        if (issuers == null) {
            return false;
        }
        boolean acceptIssuer = false;
        for (X500Principal issuer : issuers) {
            if (!targetIssuers.contains(issuer)) continue;
            acceptIssuer = true;
            break;
        }
        return acceptIssuer;
    }

    public static Stream<IX509CRL> selectCRLs(IX509CRLSelector selector, Stream<IX509CRL> crls) {
        HashSet<X500Principal> targetIssuers = new HashSet<X500Principal>();
        if (selector.getIssuers() != null) {
            targetIssuers.addAll(selector.getIssuers());
        }
        if (selector.getCertificateChecking() != null) {
            targetIssuers.add(selector.getCertificateChecking().getIssuerX500Principal());
        }
        return crls.distinct().filter(crl -> {
            try {
                return CrlTools.matchCRL(selector, targetIssuers, crl);
            }
            catch (CRLException e) {
                Log.warn(e.getMessage(), (Throwable)e);
                return false;
            }
        });
    }
}

