/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.provider.standard;

import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.filter.standard.X509CertificateFilterChain;
import de.intarsys.security.certificate.filter.standard.X509CertificateSelectorIdentity;
import de.intarsys.security.certificate.provider.CertificateProvider;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.INotificationSupport;
import java.util.Iterator;

public class PreselectCertificateProvider
implements ICertificateProvider,
INotificationSupport {
    private final IX509CertificateFilter selector;
    private ICertificateProvider baseProvider;

    public PreselectCertificateProvider(IX509CertificateFilter selector) {
        this.selector = selector;
    }

    public PreselectCertificateProvider(IX509CertificateFilter selector, ICertificateProvider baseProvider) {
        this.selector = selector;
        this.baseProvider = baseProvider;
    }

    public <T extends Event> void addNotificationListener(EventType<? extends T> type, INotificationListener<T> listener) {
        if (this.getBaseProvider() instanceof INotificationSupport) {
            ((INotificationSupport)this.getBaseProvider()).addNotificationListener(type, listener);
        }
    }

    @Override
    public boolean containsCertificate(IX509Certificate certificate) {
        return this.lookupCertificates(new X509CertificateSelectorIdentity(certificate)).hasNext();
    }

    public ICertificateProvider getBaseProvider() {
        if (this.baseProvider == null) {
            this.baseProvider = CertificateProvider.get();
        }
        return this.baseProvider;
    }

    protected IX509CertificateFilter getSelector() {
        return this.selector;
    }

    @Override
    public Iterator<IX509Certificate> lookupCertificates(IX509CertificateFilter filter) {
        return this.getBaseProvider().lookupCertificates(new X509CertificateFilterChain(this.getSelector(), filter));
    }

    public <T extends Event> void removeNotificationListener(EventType<? extends T> type, INotificationListener<T> listener) {
        if (this.getBaseProvider() instanceof INotificationSupport) {
            ((INotificationSupport)this.getBaseProvider()).removeNotificationListener(type, listener);
        }
    }
}

