/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.provider.keystore;

import de.intarsys.security.openssl.PEMCertificateGenerator;
import de.intarsys.security.openssl.PEMPrivateKeyGenerator;
import de.intarsys.security.openssl.PEMTools;
import de.intarsys.tools.authenticate.ConstantPasswordProvider;
import de.intarsys.tools.authenticate.IPasswordProvider;
import de.intarsys.tools.crypto.CryptoTools;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.StreamLocator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStoreSpi;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.bouncycastle.util.io.pem.PemGenerationException;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;

public class PEMKeyStoreSpi
extends KeyStoreSpi {
    private X509Certificate certificate;
    private PrivateKey privateKey;
    private Secret privateKeyPassword;
    private String alias;
    private PemObject pemObject;
    private PemGenerationException generationException;

    @Override
    public Enumeration<String> engineAliases() {
        return new Enumeration<String>(){
            boolean hasNext;
            {
                this.hasNext = PEMKeyStoreSpi.this.alias != null;
            }

            @Override
            public boolean hasMoreElements() {
                return this.hasNext;
            }

            @Override
            public String nextElement() {
                if (this.hasNext) {
                    this.hasNext = false;
                    return PEMKeyStoreSpi.this.alias;
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        return this.alias != null && this.alias.equals(alias);
    }

    @Override
    public void engineDeleteEntry(String alias) {
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        if (alias == null || alias.equals(this.alias)) {
            return this.certificate;
        }
        return null;
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        if (cert.equals(this.certificate)) {
            return this.alias;
        }
        return null;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        Certificate cert = this.engineGetCertificate(alias);
        if (cert != null) {
            return new Certificate[]{cert};
        }
        return null;
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        return null;
    }

    @Override
    public Key engineGetKey(String alias, char[] password) throws UnrecoverableKeyException {
        if (this.alias.equals(alias)) {
            if (this.privateKey == null) {
                try {
                    KeyPair keyPair = (KeyPair)PEMTools.readObject(this.pemObject, (IPasswordProvider)new ConstantPasswordProvider(password));
                    this.privateKey = keyPair.getPrivate();
                    this.privateKeyPassword = Secret.hide((char[])password);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (this.privateKey != null) {
                try {
                    if (!CryptoTools.isEmpty((Secret)this.privateKeyPassword) && !Arrays.equals(this.privateKeyPassword.getChars(), password)) {
                        throw new UnrecoverableKeyException("wrong password");
                    }
                }
                catch (UnrecoverableKeyException e) {
                    throw e;
                }
                catch (GeneralSecurityException e) {
                    throw new UnrecoverableKeyException(ExceptionTools.getMessage((Throwable)e));
                }
                return this.privateKey;
            }
        }
        return null;
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        return this.engineContainsAlias(alias);
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        if (this.alias.equals(alias)) {
            return this.isPrivateKey();
        }
        return false;
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException {
        Object c;
        if (stream == null) {
            return;
        }
        this.setPemObject(PEMTools.readPEMObject((ILocator)new StreamLocator(stream, "data", "pem")));
        if (!this.isPrivateKey() && (c = PEMTools.readObject(this.pemObject, null)) instanceof X509Certificate) {
            this.certificate = (X509Certificate)c;
        }
        this.alias = this.certificate instanceof X509Certificate ? this.certificate.getSubjectX500Principal().toString() : String.valueOf(System.currentTimeMillis());
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) {
        if (!(cert instanceof X509Certificate)) {
            throw new IllegalArgumentException("cert");
        }
        this.alias = alias;
        this.certificate = (X509Certificate)cert;
        this.privateKey = null;
        this.privateKeyPassword = null;
        try {
            this.pemObject = new PEMCertificateGenerator(this.certificate).generate();
            this.generationException = null;
        }
        catch (PemGenerationException e) {
            this.generationException = e;
            this.pemObject = new PemObject("CERTIFICATE", null);
        }
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) {
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) {
        this.alias = alias;
        this.certificate = null;
        this.privateKey = (PrivateKey)key;
        this.privateKeyPassword = Secret.hide((char[])password);
        try {
            this.pemObject = new PEMPrivateKeyGenerator(this.privateKey, "DES-EDE3-CBC", this.privateKeyPassword, CryptoTools.createSecureRandom()).generate();
            this.generationException = null;
        }
        catch (PemGenerationException e) {
            this.generationException = e;
            this.pemObject = new PemObject("RSA PRIVATE KEY", null);
        }
    }

    @Override
    public int engineSize() {
        return 1;
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException {
        if (this.generationException != null) {
            throw new IOException(this.generationException);
        }
        PemWriter w = new PemWriter((Writer)new OutputStreamWriter(stream));
        w.writeObject(new PemObjectGenerator(){

            public PemObject generate() throws PemGenerationException {
                return PEMKeyStoreSpi.this.pemObject;
            }
        });
        w.flush();
    }

    protected PemObject getPemObject() {
        return this.pemObject;
    }

    protected boolean isPrivateKey() {
        if (this.getPemObject() == null) {
            return false;
        }
        return "RSA PRIVATE KEY".equals(this.getPemObject().getType()) || "DSA PRIVATE KEY".equals(this.getPemObject().getType()) || "EC PRIVATE KEY".equals(this.getPemObject().getType());
    }

    protected void setPemObject(PemObject pemObject) {
        this.pemObject = pemObject;
    }
}

