/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.provider.keystore;

import de.intarsys.security.certificate.provider.keystore.CommonKeyStore;
import de.intarsys.security.certificate.provider.keystore.IKeyStore;
import de.intarsys.security.certificate.provider.keystore.IKeyStoreFactory;
import de.intarsys.security.certificate.provider.keystore.KeyStoreFacade;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.LocatorTools;
import java.io.IOException;

public class DefaultKeyStoreFactory
implements IKeyStoreFactory {
    @Override
    public IKeyStore create(ILocator locator) throws IOException {
        if (locator == null) {
            return null;
        }
        String contentType = null;
        String extension = LocatorTools.getExtension((ILocator)locator);
        if (KeyStoreFacade.TYPE_DER.equalsIgnoreCase(extension)) {
            contentType = KeyStoreFacade.guessDEREncodedType(locator);
        }
        if (contentType == null) {
            contentType = extension;
        }
        if (KeyStoreFacade.isX509(contentType)) {
            return KeyStoreFacade.createX509(locator);
        }
        if (KeyStoreFacade.isPEM(contentType)) {
            return KeyStoreFacade.createPEM(locator);
        }
        if (KeyStoreFacade.isPKCS7(contentType)) {
            return KeyStoreFacade.createPKCS7(locator);
        }
        if (KeyStoreFacade.isPKCS12(contentType)) {
            return KeyStoreFacade.createPKCS12(locator);
        }
        if (KeyStoreFacade.isJKS(contentType)) {
            return KeyStoreFacade.createJKS(locator);
        }
        if (CommonKeyStore.isATZ(contentType)) {
            return CommonKeyStore.createATZ(locator);
        }
        if (CommonKeyStore.isCRY(contentType)) {
            return CommonKeyStore.createCRY(locator);
        }
        return KeyStoreFacade.createJKS(locator);
    }
}

