/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.filter.standard;

import de.intarsys.security.certificate.filter.CommonX509CertificateFilter;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.factory.IFactorySupport;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.infoset.IElementSerializable;
import de.intarsys.tools.infoset.IElementSerializationHandler;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.util.Iterator;

public abstract class X509CertificateFilterPredicate
extends CommonX509CertificateFilter
implements IElementSerializable,
IElementConfigurable {
    private IX509CertificateFilter op1;
    private IX509CertificateFilter op2;

    protected X509CertificateFilterPredicate(IFactory factory) {
        super(factory);
    }

    protected X509CertificateFilterPredicate(IX509CertificateFilter op1, IX509CertificateFilter op2) {
        this(null);
        this.op1 = op1;
        this.op2 = op2;
    }

    public void configure(IElement element) throws ConfigurationException {
        try {
            IX509CertificateFilter tempFilter;
            IElement childElement;
            Iterator it = element.elementIterator("filter");
            if (it.hasNext()) {
                childElement = (IElement)it.next();
                tempFilter = (IX509CertificateFilter)ElementTools.createObject((IElement)childElement, IX509CertificateFilter.class, null, (IArgs)Args.create());
                this.setOp1(tempFilter);
            }
            if (it.hasNext()) {
                childElement = (IElement)it.next();
                tempFilter = (IX509CertificateFilter)ElementTools.createObject((IElement)childElement, IX509CertificateFilter.class, null, (IArgs)Args.create());
                this.setOp2(tempFilter);
            }
        }
        catch (ObjectCreationException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    public IX509CertificateFilter getOp1() {
        return this.op1;
    }

    public IX509CertificateFilter getOp2() {
        return this.op2;
    }

    @Override
    public boolean isX509NonRepudiation() {
        return this.getOp1() != null && this.getOp1().isX509NonRepudiation() || this.getOp2() != null && this.getOp2().isX509NonRepudiation();
    }

    public void serialize(IElement element) throws ElementSerializationException {
        IFactory factory;
        IElement operandElement;
        if (this.getFactory() != null) {
            element.setAttributeValue("factory", this.getFactory().getId());
        } else {
            element.setAttributeValue("class", this.getClass().getName());
        }
        IX509CertificateFilter operand = this.getOp1();
        if (operand != null) {
            operandElement = element.newElementMapped("filter");
            if (operand instanceof IElementSerializable) {
                ((IElementSerializable)operand).serialize(operandElement);
            } else if (operand instanceof IFactorySupport && (factory = ((IFactorySupport)operand).getFactory()) instanceof IElementSerializationHandler) {
                ((IElementSerializationHandler)factory).serialize((Object)operand, operandElement);
            }
        }
        if ((operand = this.getOp2()) != null) {
            operandElement = element.newElementMapped("filter");
            if (operand instanceof IElementSerializable) {
                ((IElementSerializable)operand).serialize(operandElement);
            } else if (operand instanceof IFactorySupport && (factory = ((IFactorySupport)operand).getFactory()) instanceof IElementSerializationHandler) {
                ((IElementSerializationHandler)factory).serialize((Object)operand, operandElement);
            }
        }
    }

    public void setOp1(IX509CertificateFilter op1) {
        this.op1 = op1;
    }

    public void setOp2(IX509CertificateFilter op2) {
        this.op2 = op2;
    }
}

