/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.filter.standard;

import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.filter.CommonX509CertificateFilter;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.infoset.IElementSerializable;
import de.intarsys.tools.string.StringTools;

public class X509CertificateFilterLiteral
extends CommonX509CertificateFilter
implements IElementSerializable,
IElementConfigurable {
    public static final IX509CertificateFilter ACCEPT = new X509CertificateFilterLiteral(true);
    public static final IX509CertificateFilter REJECT = new X509CertificateFilterLiteral(false);
    private boolean accept;

    protected X509CertificateFilterLiteral(boolean accept) {
        this(null);
        this.accept = accept;
    }

    protected X509CertificateFilterLiteral(IFactory factory) {
        super(factory);
    }

    @Override
    public boolean accept(IX509Certificate certificate) {
        return this.accept;
    }

    public void configure(IElement element) throws ConfigurationException {
        String value = element.attributeValue("accept", "true");
        if (!StringTools.isEmpty((String)value)) {
            this.accept = Boolean.valueOf(value);
        }
    }

    @Override
    public boolean isX509NonRepudiation() {
        return false;
    }

    public void serialize(IElement element) throws ElementSerializationException {
        if (this.getFactory() != null) {
            element.setAttributeValue("factory", this.getFactory().getId());
        } else {
            element.setAttributeValue("class", this.getClass().getName());
        }
        element.setAttributeValue("accept", String.valueOf(this.accept));
    }
}

