/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.creation;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;

public class CertificateCreationTools {
    private static final ASN1ObjectIdentifier[] ORDERING = new ASN1ObjectIdentifier[]{BCStyle.EmailAddress, BCStyle.CN, BCStyle.L, BCStyle.ST, BCStyle.O, BCStyle.OU, BCStyle.C};

    public static X500Principal createX500Principal(Map<String, String> nameAttributes) throws IOException {
        Set<String> remainingKeys = nameAttributes.keySet();
        X500NameBuilder builder = new X500NameBuilder();
        for (ASN1ObjectIdentifier identifier : ORDERING) {
            String key = identifier.getId();
            if (!nameAttributes.containsKey(key)) continue;
            builder.addRDN(identifier, nameAttributes.get(key));
            remainingKeys.remove(key);
        }
        for (String key : remainingKeys) {
            builder.addRDN(new ASN1ObjectIdentifier(key), nameAttributes.get(key));
        }
        return new X500Principal(builder.build().getEncoded("DER"));
    }
}

