/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.attribute;

import de.intarsys.asn1.common.DirectoryString;
import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.security.certificate.attribute.NamingAuthority;
import java.util.ArrayList;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;

public class ProfessionInfo
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public byte[] getAdditionalProfessionInfo() {
        ASN1ValueHolder object = this.getValueHolder().getNextTyped(0, DEROctetString.class);
        if (object != null) {
            return object.toDEROctetString().getOctets();
        }
        return null;
    }

    public String[] getAllProfessionItems() {
        String string;
        int i;
        String[] items = this.getProfessionItems();
        String[] oids = this.getProfessionOIDs();
        ArrayList<String> result = new ArrayList<String>();
        if (items != null) {
            for (i = 0; i < items.length; ++i) {
                string = items[i];
                result.add(string);
            }
        }
        if (oids != null) {
            for (i = 0; i < oids.length; ++i) {
                string = oids[i];
                result.add(string);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public NamingAuthority getNamingAuthority() {
        ASN1ValueHolder object = this.getValueHolder().getNextTaggedGetChild(0, 0, true);
        return (NamingAuthority)NamingAuthority.FACTORY.create((ASN1Encodable)object);
    }

    public String[] getProfessionItems() {
        ASN1ValueHolder seq = this.getValueHolder().getNextNotTagged(0);
        String[] items = new String[seq.size()];
        for (int i = 0; i < items.length; ++i) {
            items[i] = ((DirectoryString)DirectoryString.FACTORY.create((ASN1Encodable)seq.getChild(i))).getString();
        }
        return items;
    }

    public String[] getProfessionOIDs() {
        int index = this.isNamingAuthorityPresent() ? 2 : 1;
        ASN1ValueHolder object = this.getValueHolder().getChild(index);
        if (object == null || !object.isSequence()) {
            return null;
        }
        String[] items = new String[object.size()];
        for (int i = 0; i < items.length; ++i) {
            items[i] = object.getChild(i).toDERObjectIdentifier().getId();
        }
        return items;
    }

    public String getRegistrationNumber() {
        ASN1ValueHolder object = this.getValueHolder().getNextTyped(0, DERPrintableString.class);
        if (object != null) {
            return object.toASN1PrintableString().getString();
        }
        return null;
    }

    private boolean isNamingAuthorityPresent() {
        return this.getValueHolder().getNextTagged(0, 0) != null;
    }

    public static class Factory
    extends ASN1Based.Factory<ProfessionInfo> {
    }
}

