/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.attribute;

import de.intarsys.asn1.common.Attribute;
import de.intarsys.security.certificate.attribute.AbstractSingleValueAttribute;
import de.intarsys.security.certificate.attribute.MonetaryLimitSyntax;
import java.text.NumberFormat;
import org.bouncycastle.asn1.ASN1Encodable;

public class ISISMTTMonetaryLimit
extends AbstractSingleValueAttribute {
    public static final String OID = "1.3.36.8.3.4";
    private static NumberFormat CURRENCY_FORMAT = null;

    public ISISMTTMonetaryLimit(Attribute attribute) {
        super(attribute);
    }

    @Override
    public String getLabel() {
        return Msg.getString("ISISMTTMonetaryLimit.Label", new Object[0]);
    }

    public MonetaryLimitSyntax getMonetaryLimitSyntax() {
        return (MonetaryLimitSyntax)MonetaryLimitSyntax.FACTORY.create((ASN1Encodable)this.getAttribute().getAttrValue(0));
    }

    @Override
    public String getStringValue() {
        MonetaryLimitSyntax syntax = this.getMonetaryLimitSyntax();
        return CURRENCY_FORMAT.format(syntax.getLimit()) + " " + syntax.getCurrency();
    }

    static {
        CURRENCY_FORMAT = NumberFormat.getInstance();
        CURRENCY_FORMAT.setMinimumIntegerDigits(1);
        CURRENCY_FORMAT.setMinimumFractionDigits(2);
        CURRENCY_FORMAT.setMaximumFractionDigits(2);
    }
}

