/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.attribute;

import de.intarsys.asn1.common.Attribute;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.security.certificate.attribute.AbstractSingleValueAttribute;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.bouncycastle.asn1.ASN1GeneralizedTime;

public class DateOfBirthAttribute
extends AbstractSingleValueAttribute {
    public static String OID = "1.3.6.1.5.5.7.9.1";

    public DateOfBirthAttribute(Attribute attribute) {
        super(attribute);
    }

    public Date getDate() {
        ASN1ValueHolder value = this.getAttribute().getAttrValue(0);
        try {
            return ((ASN1GeneralizedTime)value.toASN1Primitive()).getDate();
        }
        catch (ParseException e) {
            return null;
        }
    }

    @Override
    public String getLabel() {
        return Msg.getString("DateOfBirthAttribute.Label", new Object[0]);
    }

    @Override
    public String getStringValue() {
        DateFormat df = DateFormat.getDateTimeInstance(0, 0);
        return df.format(this.getDate());
    }
}

