/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.attribute;

import de.intarsys.security.certificate.IX509Attribute;
import de.intarsys.security.certificate.IX509AttributeCertificate;
import de.intarsys.security.certificate.IX509CertificateReference;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.common.CommonX509Certificate;
import de.intarsys.tools.string.StringTools;
import java.math.BigInteger;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.util.encoders.Hex;

public abstract class CommonX509AttributeCertificate
extends CommonX509Certificate
implements IX509AttributeCertificate {
    protected CommonX509AttributeCertificate() {
    }

    @Override
    public String getType() {
        return "AttributeCertificate";
    }

    @Override
    public boolean match(IX509PublicKeyCertificate certificate) {
        IX509CertificateReference subject = this.getSubject();
        if (subject == null) {
            return false;
        }
        X500Principal subjectName = subject.getSubjectX500Principal();
        if (subjectName != null) {
            return subjectName.equals(certificate.getSubjectX500Principal());
        }
        X500Principal issuerName = this.getSubject().getIssuerX500Principal();
        BigInteger serial = this.getSubject().getSerialNumber();
        if (issuerName != null && serial != null) {
            return issuerName.equals(certificate.getIssuerX500Principal()) && serial.equals(certificate.getSerialNumber());
        }
        return false;
    }

    public String toString() {
        IX509Attribute[] attributes;
        StringBuffer buf = new StringBuffer();
        String nl = StringTools.LS;
        buf.append("  [0]         Version: ").append(this.getVersion()).append(nl);
        buf.append("         SerialNumber: ").append(this.getSerialNumber()).append(nl);
        buf.append("             IssuerDN: ").append(this.getIssuerX500Principal()).append(nl);
        buf.append("           Start Date: ").append(this.getNotBefore()).append(nl);
        buf.append("           Final Date: ").append(this.getNotAfter()).append(nl);
        if (this.getSubject().getSubjectX500Principal() == null) {
            buf.append("            Subject's IssuerDN: ").append(this.getSubject().getIssuerX500Principal()).append(nl);
            buf.append("            Subject's SerialNumber: ").append(this.getSubject().getSerialNumber()).append(nl);
        } else {
            buf.append("            SubjectDN: ").append(this.getSubject().getSubjectX500Principal()).append(nl);
        }
        buf.append("  Signature Algorithm: ").append(this.getSigAlgName()).append(nl);
        byte[] sig = this.getSignature();
        buf.append("            Signature: ").append(new String(Hex.encode((byte[])sig, (int)0, (int)20))).append(nl);
        for (int i = 20; i < sig.length; i += 20) {
            if (i < sig.length - 20) {
                buf.append("                       ").append(new String(Hex.encode((byte[])sig, (int)i, (int)20))).append(nl);
                continue;
            }
            buf.append("                       ").append(new String(Hex.encode((byte[])sig, (int)i, (int)(sig.length - i)))).append(nl);
        }
        Set<String> oids = this.getCriticalExtensionOIDs();
        if (oids != null && !oids.isEmpty()) {
            buf.append("       Critical extensions: \n");
            for (String oid : oids) {
                buf.append("                        ").append(oid).append(nl);
            }
            buf.append(nl);
        }
        if ((oids = this.getNonCriticalExtensionOIDs()) != null && !oids.isEmpty()) {
            buf.append("       Non-critical extensions: \n");
            for (String oid : oids) {
                buf.append("                        ").append(oid).append(nl);
            }
            buf.append(nl);
        }
        if ((attributes = this.getX509Attributes()) != null && attributes.length > 0) {
            buf.append("       Attributes: \n");
            for (int i = 0; i < attributes.length; ++i) {
                IX509Attribute attribute = attributes[i];
                buf.append("                        ").append(attribute.getType()).append(nl);
            }
            buf.append(nl);
        }
        return buf.toString();
    }
}

