/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.attribute;

import de.intarsys.asn1.common.Attribute;
import de.intarsys.asn1.common.GeneralName;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.attribute.AbstractSingleValueAttribute;
import de.intarsys.security.certificate.attribute.AdmissionSyntax;
import de.intarsys.security.certificate.attribute.Admissions;
import de.intarsys.security.certificate.attribute.NamingAuthority;
import de.intarsys.security.certificate.attribute.ProfessionInfo;
import de.intarsys.tools.hex.HexTools;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.isismtt.ISISMTTObjectIdentifiers;

public class AdmissionAttribute
extends AbstractSingleValueAttribute {
    public static final String OID = ISISMTTObjectIdentifiers.id_isismtt_at_admission.getId();

    public AdmissionAttribute(Attribute attribute) {
        super(attribute);
    }

    public AdmissionSyntax getAdmissionSyntax() {
        return (AdmissionSyntax)AdmissionSyntax.FACTORY.create((ASN1Encodable)this.getAttribute().getAttrValue(0));
    }

    @Override
    public String getLabel() {
        return Msg.getString("AdmissionAttribute.Label", new Object[0]);
    }

    @Override
    public String getStringValue() {
        StringBuilder sb = new StringBuilder();
        this.write(this.getAdmissionSyntax(), sb);
        return sb.toString();
    }

    protected void write(Admissions admissions, StringBuilder sb, String indent) {
        ProfessionInfo[] profInfos;
        NamingAuthority nameAuth;
        GeneralName auth = admissions.getAdmissionAuthority();
        if (auth != null) {
            sb.append(indent).append(Msg.getString("AdmissionAttribute.LabelAdmissionAuthority", new Object[0])).append(": ").append(CertificateTools.toString(auth)).append("\n");
        }
        if ((nameAuth = admissions.getNamingAuthority()) != null) {
            sb.append(indent).append(Msg.getString("AdmissionAttribute.LabelNamingAuthority", new Object[0])).append(": ").append("\n");
            this.write(nameAuth, sb, indent + "   ");
        }
        if ((profInfos = admissions.getProfessionInfos()) != null) {
            for (int i = 0; i < profInfos.length; ++i) {
                ProfessionInfo profInfo = profInfos[i];
                sb.append(indent).append(Msg.getString("AdmissionAttribute.LabelProfessionInfo", new Object[0])).append(": ").append("\n");
                this.write(profInfo, sb, indent + "   ");
            }
        }
    }

    protected void write(AdmissionSyntax admissionSyntax, StringBuilder sb) {
        Admissions[] content;
        GeneralName auth = admissionSyntax.getAdmissionAuthority();
        if (auth != null) {
            sb.append(Msg.getString("AdmissionAttribute.LabelAdmissionAuthority", new Object[0])).append(": ").append(CertificateTools.toString(auth)).append("\n");
        }
        if ((content = admissionSyntax.getContentsOfAdmissions()) != null) {
            for (int i = 0; i < content.length; ++i) {
                Admissions admissions = content[i];
                sb.append(Msg.getString("AdmissionAttribute.LabelAdmissions", new Object[0])).append(": ").append("\n");
                this.write(admissions, sb, "   ");
            }
        }
    }

    protected void write(NamingAuthority namingAuthority, StringBuilder sb, String indent) {
        String id = namingAuthority.getNamingAuthorityId();
        if (id != null) {
            sb.append(indent).append(Msg.getString("AdmissionAttribute.LabelID", new Object[0])).append(": ").append(id).append("\n");
        }
        String url = namingAuthority.getNamingAuthorityUrl();
        if (id != null) {
            sb.append(indent).append(Msg.getString("AdmissionAttribute.LabelURL", new Object[0])).append(": ").append(url).append("\n");
        }
        String text = namingAuthority.getNamingAuthorityText();
        if (id != null) {
            sb.append(indent).append(Msg.getString("AdmissionAttribute.LabelText", new Object[0])).append(": ").append(text).append("\n");
        }
    }

    protected void write(ProfessionInfo professionInfo, StringBuilder sb, String indent) {
        byte[] addInfos;
        String regNum;
        String[] profItems;
        NamingAuthority nameAuth = professionInfo.getNamingAuthority();
        if (nameAuth != null) {
            sb.append(indent).append(Msg.getString("AdmissionAttribute.LabelNamingAuthority", new Object[0])).append(": ").append("\n");
            this.write(nameAuth, sb, indent + "   ");
        }
        if ((profItems = professionInfo.getAllProfessionItems()) != null && profItems.length > 0) {
            sb.append(indent).append(Msg.getString("AdmissionAttribute.LabelProfessions", new Object[0])).append(": ");
            for (int i = 0; i < profItems.length; ++i) {
                String profItem = profItems[i];
                sb.append(profItem);
                if (i >= profItems.length - 1) continue;
                sb.append(",");
            }
            sb.append("\n");
        }
        if ((regNum = professionInfo.getRegistrationNumber()) != null) {
            sb.append(indent).append(Msg.getString("AdmissionAttribute.LabelRegistrationNumber", new Object[0])).append(": ").append(regNum).append("\n");
        }
        if ((addInfos = professionInfo.getAdditionalProfessionInfo()) != null) {
            sb.append(indent).append(Msg.getString("AdmissionAttribute.LabelAdditionalInfo", new Object[0])).append(": ").append(HexTools.bytesToHexString((byte[])addInfos)).append("\n");
        }
    }
}

