/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.validation.commonpki.qes.sigg;

import de.intarsys.security.app.validation.EnumKeyPurpose;
import de.intarsys.security.app.validation.IValidationParameters;
import de.intarsys.security.app.validation.commonpki.qes.CommonPKIProfile;
import de.intarsys.security.app.validation.commonpki.qes.ExtensionProfileSet;
import de.intarsys.security.app.validation.commonpki.qes.IExtensionProfileSet;
import de.intarsys.security.app.validation.commonpki.qes.QESCertificateReviewer;
import de.intarsys.security.app.validation.commonpki.qes.sigg.PACKAGE;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509AttributeCertificate;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.ocsp.IOCSPResponse;
import de.intarsys.security.standard.validation.CommonValidationMessages;
import de.intarsys.security.standard.validation.CommonValidationState;
import de.intarsys.security.standard.validation.QCInfo;
import de.intarsys.security.standard.validation.QCTools;
import de.intarsys.security.standard.validation.VSDefault;
import de.intarsys.security.standard.validation.VSQualificationCertificate;
import de.intarsys.security.standard.validation.ValidationAspect;
import de.intarsys.security.standard.validation.ValidationMessage;
import de.intarsys.security.standard.validation.commonpki.CryptoDates;
import de.intarsys.security.validation.IVSCertificate;
import de.intarsys.security.validation.IVSOCSP;
import de.intarsys.security.validation.IVSOCSPRequest;
import de.intarsys.security.validation.IValidationState;
import de.intarsys.tools.message.IMessageBundle;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1PrintableString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERSequence;

public class QESSigGCertificateReviewer
extends QESCertificateReviewer {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private static final String KEY_USAGE = "2.5.29.15";
    public static final Date DATE_ETSIQC_REQUIRED = new GregorianCalendar(2005, 6, 1).getTime();

    public QESSigGCertificateReviewer() {
    }

    public QESSigGCertificateReviewer(int severity) {
        super(severity);
    }

    @Override
    protected void eeBasicProcess(IVSCertificate certificateState, IValidationParameters params, VSQualificationCertificate qcState, boolean validate) {
        if (validate) {
            IX509Certificate certificate = certificateState.getX509Certificate();
            this.validateQCCompliance(certificate, params, qcState);
            this.validateRevocationData(certificateState, params, qcState);
        }
        super.eeBasicProcess(certificateState, params, qcState, validate);
    }

    @Override
    protected IExtensionProfileSet eeCreateExtensionProfileSet(IX509Certificate certificate, IValidationParameters params) {
        if (certificate instanceof IX509PublicKeyCertificate) {
            return ExtensionProfileSet.createCommonPKISigGPublicKeyCertificate(params.getKeyPurpose());
        }
        return ExtensionProfileSet.createDefault();
    }

    @Override
    protected void eeValidateAttributeCertificate(IX509AttributeCertificate certificate, IValidationParameters params, VSQualificationCertificate state) {
        super.eeValidateAttributeCertificate(certificate, params, state);
        this.fillQCInfo(certificate, state);
        this.validateValidityPeriod(certificate, state);
    }

    @Override
    protected void eeValidateSign(IX509PublicKeyCertificate certificate, IValidationParameters params, VSQualificationCertificate state) {
        super.eeValidateSign(certificate, params, state);
        this.fillQCInfo(certificate, state);
        this.validateValidityPeriod(certificate, state);
        this.validateKeyUsage(certificate, true, state);
    }

    @Override
    protected void eeValidateTimestamp(IX509PublicKeyCertificate certificate, IValidationParameters params, VSQualificationCertificate state) {
        super.eeValidateTimestamp(certificate, params, state);
        this.fillQCInfo(certificate, state);
        this.validateValidityPeriod(certificate, state);
        this.validateKeyUsage(certificate, false, state);
    }

    protected void fillQCInfo(IX509Certificate certificate, VSQualificationCertificate state) {
        QCInfo qcInfo = (QCInfo)state.getQcInfo();
        qcInfo.setGenerationDate(this.getDateOfCertGen(certificate, state));
        try {
            ASN1Primitive derLiabilityLimitationFlag = CertificateTools.getExtensionValue(certificate, "0.2.262.1.10.12.0");
            ASN1Boolean liabilityLimitationFlag = ASN1Boolean.getInstance((Object)derLiabilityLimitationFlag);
            if (liabilityLimitationFlag != null) {
                qcInfo.setLiabilityLimited(liabilityLimitationFlag.isTrue());
            }
        }
        catch (IOException e) {
            state.invalidate(CommonValidationMessages.ERROR_IO_EXTENSION(e, "0.2.262.1.10.12.0"));
        }
        try {
            ASN1Primitive derICCSN = CertificateTools.getExtensionValue(certificate, "1.3.36.8.3.6");
            ASN1OctetString iccsn = ASN1OctetString.getInstance((Object)derICCSN);
            if (iccsn != null) {
                qcInfo.setICCSN(iccsn.getOctets());
            }
        }
        catch (IOException e) {
            state.invalidate(CommonValidationMessages.ERROR_IO_EXTENSION(e, "0.2.262.1.10.12.0"));
        }
        try {
            ASN1Primitive monetaryLimit = CertificateTools.getExtensionValue(certificate, "1.3.36.8.3.4");
            if (monetaryLimit != null) {
                ASN1Sequence seq = DERSequence.getInstance((Object)monetaryLimit);
                ASN1PrintableString currency = ASN1PrintableString.getInstance((Object)seq.getObjectAt(0));
                ASN1Integer amount = ASN1Integer.getInstance((Object)seq.getObjectAt(1));
                ASN1Integer exponent = ASN1Integer.getInstance((Object)seq.getObjectAt(2));
                String currencyString = currency.getString();
                int limit = (int)((double)amount.getValue().intValue() * Math.pow(10.0, exponent.getValue().intValue()));
                if (qcInfo.getLimitCurrency() == null) {
                    qcInfo.setLimitCurrency(currencyString);
                } else if (!qcInfo.getLimitCurrency().equals(currencyString)) {
                    state.invalidate(Msg.getString("QESSigGCertificateReviewer.InconsistentMonetaryLimit", new Object[0]));
                }
                if (qcInfo.getLimitValue() == -1.0) {
                    qcInfo.setLimitValue(limit);
                } else if (qcInfo.getLimitValue() != (double)limit) {
                    state.invalidate(Msg.getString("QESSigGCertificateReviewer.InconsistentMonetaryLimit", new Object[0]));
                }
            }
        }
        catch (IOException e) {
            state.invalidate(CommonValidationMessages.ERROR_IO_EXTENSION(e, "1.3.36.8.3.4"));
        }
    }

    @Override
    protected CommonPKIProfile getValidityPolicy() {
        return CommonPKIProfile.QES_SigG;
    }

    @Override
    protected void issuerBasicProcess(IVSCertificate certificateState, IValidationParameters params, VSQualificationCertificate qcState, boolean validate) {
        if (validate) {
            IX509Certificate certificate = certificateState.getX509Certificate();
            this.validateQCCompliance(certificate, params, qcState);
            this.validateRevocationData(certificateState, params, qcState);
        }
    }

    @Override
    protected IExtensionProfileSet issuerCreateExtensionProfileSet(IX509Certificate certificate, IValidationParameters params) {
        return ExtensionProfileSet.createCommonPKISigGPublicKeyCertificate(params.getKeyPurpose());
    }

    protected void validateKeyUsage(IX509PublicKeyCertificate certificate, boolean requireKeyUsage, VSQualificationCertificate state) {
        ASN1Primitive derKeyUsage = null;
        try {
            derKeyUsage = CertificateTools.getExtensionValue(certificate, KEY_USAGE);
        }
        catch (IOException e) {
            state.invalidate(CommonValidationMessages.ERROR_IO_EXTENSION(e, KEY_USAGE));
            return;
        }
        if (derKeyUsage == null) {
            if (requireKeyUsage) {
                state.invalidate(CommonValidationMessages.ERROR_MISSING_EXTENSION(KEY_USAGE));
            }
            return;
        }
        DERBitString keyUsage = DERBitString.convert((ASN1BitString)ASN1BitString.getInstance((Object)derKeyUsage));
        if ((keyUsage.intValue() & 0x40) == 0) {
            state.invalidate(Msg.getString("QESSigGCertificateReviewer.InvalidKeyUsage", new Object[0]));
        }
        if ((keyUsage.intValue() | 0x40 | 0x80) != 192) {
            state.invalidate(Msg.getString("QESSigGCertificateReviewer.InvalidKeyUsage", new Object[0]));
        }
    }

    protected void validateOCSPRequest(IX509Certificate certificate, IVSOCSPRequest request, VSQualificationCertificate state) {
        if (!request.isValid()) {
            return;
        }
        VSDefault ocspAspect = new VSDefault();
        ocspAspect.setSeverity(this.getSeverity());
        if (request.hasPositiveStatement()) {
            ocspAspect.increaseState(0);
        } else {
            IOCSPResponse response = request.getResponse();
            if (response.getProducedAt().before(CryptoDates.END_OF_SIGG)) {
                ocspAspect.addMessage(ValidationMessage.createError(Msg.getString("QESSigGOCSPService.NoPositiveStatement", new Object[0])));
                ocspAspect.increaseState(2);
            }
            Date certExpiryDate = certificate.getNotAfter();
            Date cutoff = request.getArchiveCutoff();
            if (cutoff.after(certExpiryDate)) {
                ocspAspect.addMessage(ValidationMessage.createError(Msg.getString("QESSigGOCSPService.NoReliableInformation", new Object[0])));
                ocspAspect.increaseState(2);
            }
        }
        ((CommonValidationState)((Object)request)).addAspect(ValidationAspect.with("SigG", (IValidationState)ocspAspect));
        state.increaseState(ocspAspect);
    }

    protected void validateQCCompliance(IX509Certificate certificate, IValidationParameters params, VSQualificationCertificate state) {
        if (params.getKeyPurpose() == EnumKeyPurpose.TIMESTAMPING) {
            return;
        }
        Date dateIssued = this.getDateOfCertGen(certificate, state);
        if (dateIssued == null) {
            dateIssued = certificate.getNotBefore();
        }
        if (!dateIssued.before(DATE_ETSIQC_REQUIRED)) {
            try {
                if (!QCTools.hasETSIQCComplianceStatement(certificate)) {
                    String errorMsg = Msg.getString("QESSigGCertificateReviewer.WarningNotQCCompliant", new Object[0]);
                    state.invalidate(ValidationMessage.createError(errorMsg));
                }
            }
            catch (IOException e) {
                state.invalidate(CommonValidationMessages.ERROR_IO_EXTENSION(e, "1.3.6.1.5.5.7.1.3"));
            }
        }
        try {
            if (QCTools.hasISISMTTAccreditedAccreditedPolicy(certificate)) {
                state.addMessage(ValidationMessage.createInfo(Msg.getString("QESSigGCertificateReviewer.InfoAccredited", new Object[0])));
            }
        }
        catch (IOException e) {
            state.invalidate(CommonValidationMessages.ERROR_IO_EXTENSION(e, "2.5.29.32"));
        }
    }

    protected void validateRevocationData(IVSCertificate certificateState, IValidationParameters params, VSQualificationCertificate state) {
        IVSOCSPRequest requestState;
        IVSOCSP ocspState = certificateState.getOCSPState();
        IVSOCSPRequest iVSOCSPRequest = requestState = ocspState == null ? null : (IVSOCSPRequest)ocspState.getSuccessfulRequestState();
        if (requestState != null) {
            this.validateOCSPRequest(certificateState.getX509Certificate(), requestState, state);
        }
    }

    protected void validateValidityPeriod(IX509Certificate certificate, VSQualificationCertificate state) {
        Date validityStart = certificate.getNotBefore();
        Date validityEnd = certificate.getNotAfter();
        if (validityStart == null || validityEnd == null) {
            state.invalidate(Msg.getString("QESSigGCertificateReviewer.ValidityPeriodUndefined", new Object[0]));
        } else {
            Calendar calStart = Calendar.getInstance();
            calStart.setTime(validityStart);
            Calendar calEnd = Calendar.getInstance();
            calEnd.setTime(validityEnd);
            calStart.add(1, 10);
            if (calStart.before(calEnd)) {
                state.invalidate(Msg.getString("QESSigGCertificateReviewer.ValidityPeriodTooLong", new Object[0]));
            }
        }
    }
}

