/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.validation.commonpki;

import de.intarsys.security.app.validation.EnumKeyPurpose;
import de.intarsys.security.app.validation.ICRLService;
import de.intarsys.security.app.validation.IValidationParameters;
import de.intarsys.security.app.validation.ValidationParameters;
import de.intarsys.security.app.validation.X509SignatureValidator;
import de.intarsys.security.app.validation.common.ValidationContext;
import de.intarsys.security.app.validation.commonpki.PACKAGE;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509CertificatePath;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.common.CollectionCertificateProvider;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.provider.CompositeCertificateProvider;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.crl.ICRLProvider;
import de.intarsys.security.crl.IX509CRL;
import de.intarsys.security.crl.common.CrlTools;
import de.intarsys.security.crl.common.EmbeddedCRLProvider;
import de.intarsys.security.crl.common.X509CRLSelector;
import de.intarsys.security.standard.validation.CommonValidationMessages;
import de.intarsys.security.standard.validation.VSCRL;
import de.intarsys.security.standard.validation.VSCRLRequest;
import de.intarsys.security.standard.validation.VSCertificate;
import de.intarsys.security.standard.validation.VSSignature;
import de.intarsys.security.standard.validation.ValidationMessage;
import de.intarsys.security.validation.IOrigin;
import de.intarsys.security.validation.IOriginProvider;
import de.intarsys.security.validation.IVSCRL;
import de.intarsys.security.validation.IVSCertificate;
import de.intarsys.security.validation.IVSSignature;
import de.intarsys.security.validation.IVTCertificate;
import de.intarsys.tools.adapter.AdapterTools;
import de.intarsys.tools.date.DateEnvironment;
import de.intarsys.tools.function.Functions;
import de.intarsys.tools.function.OnError;
import de.intarsys.tools.function.Predicates;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.streaming.StreamingTools;
import java.io.IOException;
import java.security.cert.CRLException;
import java.security.cert.X509CRLEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonPKICRLService
implements ICRLService {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private Logger Log = LoggerFactory.getLogger(CommonPKICRLService.class);

    protected static List<String> getCrlURLs(AuthorityInformationAccess authInfoAccess) {
        ArrayList<String> urls = new ArrayList<String>();
        AccessDescription[] ads = authInfoAccess.getAccessDescriptions();
        for (int i = 0; i < ads.length; ++i) {
            GeneralName location;
            if (!ads[i].getAccessMethod().equals((ASN1Primitive)AccessDescription.id_ad_caIssuers) || (location = ads[i].getAccessLocation()).getTagNo() != 6) continue;
            String url = ((DERIA5String)location.getName()).getString();
            urls.add(url);
        }
        return urls;
    }

    protected boolean checkCertificateStatus(VSCRLRequest state, IX509CRL crl, IX509Certificate certificate, IX509CertificatePath certificatePath, IValidationParameters params) {
        try {
            if (!crl.isRevoked(certificate)) {
                state.setRevocationState(Msg.getString("CommonPKICRLService.RevocationStateGood", new Object[0]));
                state.increaseState(0);
                return true;
            }
        }
        catch (CRLException e) {
            state.setRevocationState(Msg.getString("CommonPKICRLService.RevocationStateUnknown", new Object[0]));
            state.increaseState(2);
            state.addMessage(CommonValidationMessages.ERROR_CERTIFICATE(e));
            return false;
        }
        try {
            X509CRLEntry entry = crl.getRevokedCertificate(certificate);
            if (params.getDateToTest().before(entry.getRevocationDate())) {
                state.setRevocationState(Msg.getString("CommonPKICRLService.RevocationStateGood", new Object[0]));
                state.increaseState(0);
                return true;
            }
            state.increaseState(3);
            state.addMessage(ValidationMessage.createError(Msg.getString("CommonPKICRLService.MessageCertificateRevoked", new Object[0])));
            state.setRevocationState(Msg.getString("CommonPKICRLService.RevocationStateRevoked", new Object[0]));
            state.setRevocationDate(entry.getRevocationDate());
            int intReasonCode = 0;
            try {
                ASN1Primitive derReason = CertificateTools.getExtensionValue(entry, "2.5.29.21");
                ASN1Enumerated reasonCode = ASN1Enumerated.getInstance((Object)derReason);
                if (reasonCode != null) {
                    intReasonCode = reasonCode.getValue().intValue();
                }
            }
            catch (IOException e) {
                state.addMessage(CommonValidationMessages.ERROR_IO_EXTENSION(e, "2.5.29.21"));
            }
            state.setRevocationReason(intReasonCode);
            return true;
        }
        catch (CRLException e) {
            state.setRevocationState(Msg.getString("CommonPKICRLService.RevocationStateUnknown", new Object[0]));
            state.increaseState(2);
            state.addMessage(CommonValidationMessages.ERROR_CERTIFICATE(e));
            return false;
        }
    }

    protected boolean checkCRL(IX509CRL crl, IX509Certificate certificate, IX509CertificatePath certificatePath, VSCRL state, IValidationParameters params) {
        VSCRLRequest requestState = new VSCRLRequest(crl);
        IOriginProvider originProvider = (IOriginProvider)AdapterTools.getAdapter((Object)crl.getCRLProvider(), IOriginProvider.class, null);
        if (originProvider != null) {
            IOrigin origin = originProvider.getOrigin(crl);
            requestState.setOrigin(origin);
        }
        this.validateCRL(crl, certificate, certificatePath, params, requestState);
        boolean propagateState = requestState.isValid();
        boolean bl = propagateState = propagateState && this.checkCertificateStatus(requestState, crl, certificate, certificatePath, params);
        if (!propagateState) {
            requestState.setSeverity(2);
        }
        state.addRequestState(requestState);
        return propagateState;
    }

    protected void checkCRLs(IX509Certificate certificate, IX509CertificatePath certificatePath, AuthorityInformationAccess authInfoAccess, VSCRL state, IValidationParameters params) {
        List<String> urls = CommonPKICRLService.getCrlURLs(authInfoAccess);
        X500Principal crlIssuer = certificate.getIssuerX500Principal();
        Stream<IX509CRL> crls = urls.stream().flatMap(Functions.tryCatch(url -> this.lookupCRLs(certificate, (String)url, crlIssuer, params), ex -> {
            state.addMessage(ValidationMessage.createWarning(ex.getMessage()));
            return null;
        })).filter(Predicates.isNotNull());
        this.checkCRLs(crls, certificate, certificatePath, state, params);
    }

    protected void checkCRLs(IX509Certificate certificate, IX509CertificatePath certificatePath, CRLDistPoint crlDistPoints, VSCRL state, IValidationParameters params) {
        DistributionPoint[] distPoints = crlDistPoints.getDistributionPoints();
        Arrays.sort(distPoints, this::compareDistributionPoints);
        Stream<IX509CRL> crls = null;
        for (int i = 0; i < distPoints.length; ++i) {
            GeneralName[] crlIssuerNames;
            DistributionPoint crlDistPoint = distPoints[i];
            if (crlDistPoint.getCRLIssuer() == null || (crlIssuerNames = crlDistPoint.getCRLIssuer().getNames()).length <= 0) continue;
            try {
                crls = this.getIndirectCRLs(certificate, crlDistPoint, params);
                break;
            }
            catch (IOException e) {
                state.addMessage(ValidationMessage.createWarning(e.getMessage()));
            }
        }
        if (this.checkCRLs(crls, certificate, certificatePath, state, params)) {
            return;
        }
        try {
            crls = this.getDirectCRLs(certificate, crlDistPoints, params);
        }
        catch (IOException e) {
            state.addMessage(ValidationMessage.createWarning(e.getMessage()));
        }
        this.checkCRLs(crls, certificate, certificatePath, state, params);
    }

    protected void checkCRLs(IX509Certificate certificate, IX509CertificatePath certificatePath, VSCRL state, IValidationParameters params) {
        Stream<IX509CRL> crls = null;
        try {
            crls = this.lookupCRLs(certificate, null, certificate.getIssuerX500Principal(), params);
        }
        catch (IOException e) {
            state.addMessage(ValidationMessage.createWarning(e.getMessage()));
        }
        this.checkCRLs(crls, certificate, certificatePath, state, params);
    }

    protected boolean checkCRLs(Stream<IX509CRL> crls, IX509Certificate certificate, IX509CertificatePath certificatePath, VSCRL state, IValidationParameters params) {
        if (crls == null) {
            return false;
        }
        Optional<IX509CRL> acceptedCrl = crls.distinct().filter(crl -> this.checkCRL((IX509CRL)crl, certificate, certificatePath, state, params)).findFirst();
        return acceptedCrl.isPresent();
    }

    protected int compareDistributionPoints(DistributionPoint dp1, DistributionPoint dp2) {
        Optional<String> url1 = this.getUrl(dp1);
        if (url1.isPresent() && url1.get().startsWith("http")) {
            return -1;
        }
        return 1;
    }

    protected Stream<IX509CRL> getCRLs(IX509Certificate certificate, DistributionPoint crlDistPoint, X500Principal crlIssuer, IValidationParameters params) throws IOException {
        DistributionPointName dp_name = crlDistPoint.getDistributionPoint();
        if (dp_name.getType() == 0) {
            GeneralName[] generalNames = GeneralNames.getInstance((Object)dp_name.getName()).getNames();
            return this.getCRLsFromNames(generalNames, certificate, crlIssuer, params, Optional.empty());
        }
        return Stream.empty();
    }

    protected Stream<IX509CRL> getCRLsFromIssuerAltNames(IX509Certificate certificate, X500Principal crlIssuer, IValidationParameters params) throws IOException {
        GeneralNames altNames = GeneralNames.getInstance((Object)CertificateTools.getExtensionValue(certificate, "2.5.29.18"));
        if (altNames == null) {
            return Stream.empty();
        }
        return this.getCRLsFromNames(altNames.getNames(), certificate, crlIssuer, params, Optional.of(url -> url.startsWith("ldap://")));
    }

    protected Stream<IX509CRL> getCRLsFromNames(GeneralName[] names, IX509Certificate certificate, X500Principal crlIssuer, IValidationParameters params, Optional<Predicate<String>> acceptUrl) throws IOException {
        if (names == null) {
            return Stream.empty();
        }
        return Arrays.stream(names).filter(altName -> altName.getTagNo() == 6).map(altName -> ((DERIA5String)altName.getName()).getString()).filter(acceptUrl.orElse(Predicates.beTrue())).flatMap(url -> {
            try {
                return this.lookupCRLs(certificate, (String)url, crlIssuer, params);
            }
            catch (Exception e) {
                this.Log.warn(e.getMessage(), (Throwable)e);
                return Stream.empty();
            }
        });
    }

    protected Stream<IX509CRL> getDirectCRLs(IX509Certificate certificate, CRLDistPoint crlDistPoints, IValidationParameters params) throws IOException {
        Stream crls = Stream.empty();
        X500Principal crlIssuer = certificate.getIssuerX500Principal();
        DistributionPoint[] distPoints = crlDistPoints.getDistributionPoints();
        crls = Arrays.stream(distPoints).filter(dp -> this.getUrl((DistributionPoint)dp).filter(s -> s.startsWith("http")).isPresent()).flatMap(OnError.rethrow(distPoint -> this.getCRLs(certificate, (DistributionPoint)distPoint, crlIssuer, params)));
        crls = StreamingTools.concatIfEmpty(crls, (Supplier)OnError.rethrow(() -> Arrays.stream(distPoints).filter(dp -> !this.getUrl((DistributionPoint)dp).filter(s -> s.startsWith("http")).isPresent()).flatMap(OnError.rethrow(distPoint -> this.getCRLs(certificate, (DistributionPoint)distPoint, crlIssuer, params)))));
        crls = StreamingTools.concatIfEmpty((Stream)crls, (Supplier)OnError.rethrow(() -> this.getCRLsFromIssuerAltNames(certificate, crlIssuer, params)));
        return crls;
    }

    protected Stream<IX509CRL> getIndirectCRLs(IX509Certificate certificate, DistributionPoint crlDistPoint, IValidationParameters params) throws IOException {
        GeneralName[] crlIssuerNames = crlDistPoint.getCRLIssuer().getNames();
        X500Name crlIssuerName = X500Name.getInstance((Object)crlIssuerNames[0].getName());
        X500Principal crlIssuer = new X500Principal(crlIssuerName.getEncoded());
        return this.getCRLs(certificate, crlDistPoint, crlIssuer, params);
    }

    protected Optional<String> getUrl(DistributionPoint distributionPoint) {
        DistributionPointName dp_name = distributionPoint.getDistributionPoint();
        if (dp_name.getType() != 0) {
            return null;
        }
        GeneralName[] names = GeneralNames.getInstance((Object)dp_name.getName()).getNames();
        if (names == null) {
            return null;
        }
        return Arrays.stream(names).filter(altName -> altName.getTagNo() == 6).map(altName -> ((DERIA5String)altName.getName()).getString()).findFirst();
    }

    protected boolean isDeltaCRL(IX509CRL crl) throws IOException {
        ASN1Primitive derIndicator = CertificateTools.getExtensionValue(crl, "2.5.29.27");
        return derIndicator != null;
    }

    protected Stream<IX509CRL> lookupCRLs(IX509Certificate certificate, String url, X500Principal crlIssuer, IValidationParameters parameters) throws IOException {
        X509CRLSelector selector = new X509CRLSelector();
        selector.setCertificateChecking(certificate);
        selector.addIssuer(crlIssuer);
        selector.setDateAndTime(parameters.getDateToTest());
        ICRLProvider crlProvider = parameters.getCRLProvider();
        if (parameters.getExtendedValidationData() != null) {
            EmbeddedCRLProvider embeddedProvider = new EmbeddedCRLProvider();
            embeddedProvider.addDelegateProvider(crlProvider);
            parameters.getExtendedValidationData().getCRLs().forEach(crl -> embeddedProvider.addCRL((IX509CRL)crl));
            crlProvider = embeddedProvider;
        }
        Stream<IX509CRL> result = crlProvider.lookupCRLs(selector, url);
        return result;
    }

    @Override
    public IVSCRL validateCertificate(IX509Certificate certificate, IX509CertificatePath certificatePath, IValidationParameters params) {
        VSCRL crlState = new VSCRL();
        ASN1Primitive crlDp = null;
        try {
            crlDp = CertificateTools.getExtensionValue(certificate, "2.5.29.31");
        }
        catch (IOException e) {
            crlState.increaseState(2);
            crlState.addMessage(ValidationMessage.createError(Msg.getString("CommonPKICRLService.ErrorDecodingCRLDP", new Object[0])));
        }
        if (crlDp != null) {
            CRLDistPoint crlDistPoints = CRLDistPoint.getInstance((Object)crlDp);
            this.checkCRLs(certificate, certificatePath, crlDistPoints, crlState, params);
        }
        if (crlState.isUndefined()) {
            this.checkCRLs(certificate, certificatePath, crlState, params);
        }
        if (crlState.isUndefined()) {
            crlState.increaseState(2);
            crlState.addMessage(ValidationMessage.createError(Msg.getString("CommonPKICRLService.ErrorNoValidCRLFound", new Object[0])));
        }
        return crlState;
    }

    protected void validateCRL(IX509CRL crl, IX509Certificate certificate, IX509CertificatePath certificatePath, IValidationParameters params, VSCRLRequest state) {
        Date thisUpdate = crl.getThisUpdate();
        if (thisUpdate != null && thisUpdate.after(DateEnvironment.get().now())) {
            state.increaseState(3);
            return;
        }
        Date nextUpdate = crl.getNextUpdate();
        if (nextUpdate != null && params.getDateToTest().after(nextUpdate)) {
            state.invalidate(Msg.getString("CommonPKICRLService.ErrorCRLOutdated", new Object[0]));
            return;
        }
        try {
            if (this.isDeltaCRL(crl)) {
                state.invalidate(Msg.getString("CommonPKICRLService.ErrorDeltaCRLNotSupported", new Object[0]));
                return;
            }
        }
        catch (IOException e) {
            state.invalidate(CommonValidationMessages.ERROR_IO_EXTENSION(e, "2.5.29.27"));
            return;
        }
        try {
            ASN1Primitive derIDP = CertificateTools.getExtensionValue(crl, "2.5.29.28");
            IssuingDistributionPoint idp = IssuingDistributionPoint.getInstance((Object)derIDP);
            if (idp != null) {
                if (certificate.getType() == "AttributeCertificate" && (idp.onlyContainsCACerts() || idp.onlyContainsUserCerts())) {
                    state.invalidate(Msg.getString("CommonPKICRLService.ErrorIDPNoACs", new Object[0]));
                    return;
                }
                if (CertificateTools.isEndCA(certificate)) {
                    if (idp.onlyContainsAttributeCerts() || idp.onlyContainsUserCerts()) {
                        state.invalidate(Msg.getString("CommonPKICRLService.ErrorIDPNoCAs", new Object[0]));
                        return;
                    }
                } else if (idp.onlyContainsAttributeCerts() || idp.onlyContainsCACerts()) {
                    state.invalidate(Msg.getString("CommonPKICRLService.ErrorIDPNoEEs", new Object[0]));
                    return;
                }
            }
        }
        catch (IOException e) {
            state.invalidate(CommonValidationMessages.ERROR_IO_EXTENSION(e, "2.5.29.28"));
            return;
        }
        IX509CertificateFilter selector = CrlTools.createIssuerSelector(crl);
        if (selector == null) {
            state.increaseState(3);
            return;
        }
        IX509PublicKeyCertificate crlIssuer = null;
        IVSCertificate certificateState = null;
        if (certificateState == null) {
            ValidationParameters myParams = ValidationParameters.copy(params);
            myParams.setKeyPurpose(EnumKeyPurpose.CRL_SIGNING);
            myParams.setDateToTest(crl.getThisUpdate(), true);
            ICertificateProvider trusted = myParams.getTrustedCerts();
            CompositeCertificateProvider newTrusted = new CompositeCertificateProvider();
            newTrusted.registerCertificateProvider(new CollectionCertificateProvider(certificatePath.getPath()));
            newTrusted.registerCertificateProvider(trusted);
            myParams.setTrustedCerts(newTrusted);
            certificateState = this.validateIssuer(selector, (IValidationParameters)myParams);
            if (certificateState.getValidationTarget() != null) {
                crlIssuer = (IX509PublicKeyCertificate)certificateState.getValidationTarget().getImpl();
            }
        }
        state.setCertificateState(certificateState);
        IVSSignature sigState = null;
        if (crlIssuer == null) {
            sigState = new VSSignature(null, 2);
            sigState.addMessage(ValidationMessage.createError(Msg.getString("CommonPKICRLService.ErrorSignerCertNotFound", new Object[0])));
        } else {
            X509SignatureValidator<IX509CRL> validator = X509SignatureValidator.createCRLInstance();
            sigState = validator.validate(crl, crlIssuer);
        }
        state.setSignatureState(sigState);
        HashSet<String> criticalExtensions = new HashSet<String>();
        if (crl.getCriticalExtensionOIDs() != null) {
            criticalExtensions.addAll(crl.getCriticalExtensionOIDs());
        }
        criticalExtensions.remove("2.5.29.35");
        criticalExtensions.remove("2.5.29.20");
        criticalExtensions.remove("2.5.29.27");
        criticalExtensions.remove("2.5.29.28");
        if (!criticalExtensions.isEmpty()) {
            for (String extensionId : criticalExtensions) {
                state.invalidate(CommonValidationMessages.ERROR_UNPROCESSED_CRITICAL_EXTENSION(extensionId));
            }
        }
    }

    protected IVSCertificate validateIssuer(IX509Certificate certificate, IValidationParameters params) {
        return ValidationContext.get().getCertificateValidator().validate(certificate, params);
    }

    protected IVSCertificate validateIssuer(IX509CertificateFilter selector, IValidationParameters params) {
        CompositeCertificateProvider certificatePool = new CompositeCertificateProvider();
        certificatePool.registerCertificateProvider(params.getTrustedCerts());
        certificatePool.registerCertificateProvider(params.getAdditionalCerts());
        Iterator<IX509Certificate> issuerCertificates = certificatePool.lookupCertificates(selector);
        IVSCertificate issuerResult = this.validateIssuers(issuerCertificates, params);
        return issuerResult;
    }

    protected IVSCertificate validateIssuers(Iterator<IX509Certificate> issuerCertificates, IValidationParameters params) {
        IVSCertificate issuerResult = null;
        while (issuerCertificates.hasNext()) {
            IX509Certificate issuerCertificate = issuerCertificates.next();
            issuerResult = this.validateIssuer(issuerCertificate, params);
            if (issuerResult == null || !issuerResult.isValid()) continue;
            return issuerResult;
        }
        if (issuerResult == null) {
            issuerResult = new VSCertificate((IVTCertificate)null, -1);
        }
        return issuerResult;
    }
}

