/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.validation.commonpki;

import de.intarsys.security.app.validation.ICertificateChecker;
import de.intarsys.security.app.validation.IValidationParameters;
import de.intarsys.security.app.validation.commonpki.PACKAGE;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.extension.common.ICCSNHandler;
import de.intarsys.security.standard.validation.CommonValidationMessages;
import de.intarsys.security.standard.validation.VSCertificate;
import de.intarsys.security.standard.validation.ValidationMessage;
import de.intarsys.tools.message.IMessageBundle;
import java.io.IOException;
import java.util.Set;
import org.bouncycastle.asn1.isismtt.ISISMTTObjectIdentifiers;

public class CertificateICCSNChecker
implements ICertificateChecker {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private static final String ICCSN = ISISMTTObjectIdentifiers.id_isismtt_at_iCCSN.getId();

    @Override
    public void checkCertificate(IX509Certificate certificate, IValidationParameters params, Set<String> unresolvedCriticalExtensions, VSCertificate state) {
        String iccsn = null;
        try {
            iccsn = ICCSNHandler.getICCSN(certificate);
        }
        catch (IOException e) {
            state.invalidate(CommonValidationMessages.ERROR_IO_EXTENSION(e, ICCSN));
        }
        if (iccsn != null) {
            state.addMessage(ValidationMessage.createInfo(Msg.getString("CertificateICCSNChecker.InfoICCSN", new Object[]{iccsn})));
        }
        this.removeSupportedExtensions(certificate, unresolvedCriticalExtensions);
    }

    protected void removeSupportedExtensions(IX509Certificate certificate, Set<String> unresolvedCriticalExtensions) {
        unresolvedCriticalExtensions.remove(ICCSN);
    }
}

