/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.validation.common;

import de.intarsys.security.app.validation.ICRLService;
import de.intarsys.security.app.validation.ICertificatePathBuilder;
import de.intarsys.security.app.validation.ICertificatePathValidator;
import de.intarsys.security.app.validation.ICertificateValidator;
import de.intarsys.security.app.validation.IOCSPService;
import de.intarsys.security.app.validation.ISignatureContainerEntryValidator;
import de.intarsys.security.app.validation.ISignatureContainerValidator;
import de.intarsys.security.app.validation.ISignatureEntryValidator;
import de.intarsys.security.app.validation.ITimestampValidator;
import de.intarsys.security.app.validation.IValidationContext;
import de.intarsys.security.app.validation.IValidationParameters;
import de.intarsys.security.app.validation.common.CommonValidationContext;
import de.intarsys.security.app.validation.common.DefaultValidationContextFactory;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509CertificatePath;
import de.intarsys.security.certificate.common.X509CertificatePath;
import de.intarsys.security.signature.ISignatureContainer;
import de.intarsys.security.signature.ISignatureContainerEntry;
import de.intarsys.security.signature.ISignatureEntry;
import de.intarsys.security.standard.validation.DefaultValidationTarget;
import de.intarsys.security.standard.validation.VSCRL;
import de.intarsys.security.standard.validation.VSCertificate;
import de.intarsys.security.standard.validation.VSCertificatePath;
import de.intarsys.security.standard.validation.VSOCSP;
import de.intarsys.security.standard.validation.VSSignatureContainer;
import de.intarsys.security.standard.validation.VSSignatureContainerEntry;
import de.intarsys.security.standard.validation.VSSignatureEntry;
import de.intarsys.security.standard.validation.VSTimestamp;
import de.intarsys.security.timestamp.ITimestampToken;
import de.intarsys.security.validation.IVSCRL;
import de.intarsys.security.validation.IVSCertificate;
import de.intarsys.security.validation.IVSCertificatePath;
import de.intarsys.security.validation.IVSOCSP;
import de.intarsys.security.validation.IVSSignatureContainer;
import de.intarsys.security.validation.IVSSignatureContainerEntry;
import de.intarsys.security.validation.IVSSignatureEntry;
import de.intarsys.security.validation.IVSTimestamp;
import de.intarsys.tools.collection.ListTools;
import de.intarsys.tools.component.Singleton;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;

@Singleton
public class ValidationContext
extends CommonValidationContext {
    private static final ISignatureContainerValidator NULL_SIGNATURECONTAINERVALIDATOR = new ISignatureContainerValidator(){

        public IVSSignatureContainer validate(ISignatureContainer signatureContainer, IDigest digest, IValidationParameters parameters) {
            return new VSSignatureContainer(signatureContainer);
        }
    };
    private static final ISignatureContainerEntryValidator NULL_SIGNATURECONTAINERENTRYVALIDATOR = new ISignatureContainerEntryValidator(){

        public IVSSignatureContainerEntry validate(ISignatureContainerEntry entry, IDigest digest, IValidationParameters parameters) {
            return new VSSignatureContainerEntry(new DefaultValidationTarget(entry));
        }
    };
    private static final ISignatureEntryValidator NULL_SIGNATUREENTRYVALIDATOR = new ISignatureEntryValidator(){

        @Override
        public IVSSignatureEntry validate(ISignatureEntry signatureEntry, IDigest digest, IValidationParameters parameters) {
            return new VSSignatureEntry(signatureEntry);
        }
    };
    private static final ITimestampValidator NULL_TIMESTAMPVALIDATOR = new ITimestampValidator(){

        @Override
        public IVSTimestamp validate(ITimestampToken timestamp, IDigest digest, IValidationParameters parameters) {
            return new VSTimestamp(timestamp);
        }
    };
    private static final ICertificateValidator NULL_CERTIFICATEVALIDATOR = new ICertificateValidator(){

        @Override
        public IVSCertificate validate(IX509Certificate certificate, IValidationParameters params) {
            return new VSCertificate(certificate);
        }
    };
    private static final ICertificatePathValidator NULL_CERTIFICATEPATHVALIDATOR = new ICertificatePathValidator(){

        @Override
        public IVSCertificatePath validateCertificatePath(IX509CertificatePath certPath, IValidationParameters params) {
            return new VSCertificatePath(certPath);
        }
    };
    private static final ICertificatePathBuilder NULL_CERTIFICATEPATHBUILDER = new ICertificatePathBuilder(){

        @Override
        public IVSCertificatePath buildCertificatePath(IX509Certificate certificate, IValidationParameters params) {
            return new VSCertificatePath(new X509CertificatePath(ListTools.with((Object[])new IX509Certificate[]{certificate})));
        }
    };
    private static final IOCSPService NULL_OCSPSERVICE = new IOCSPService(){

        @Override
        public IVSOCSP validateCertificate(IX509Certificate certificate, IX509CertificatePath certificatePath, IValidationParameters params) {
            return new VSOCSP();
        }
    };
    private static final ICRLService NULL_CRLSERVICE = new ICRLService(){

        @Override
        public IVSCRL validateCertificate(IX509Certificate certificate, IX509CertificatePath certificatePath, IValidationParameters params) {
            return new VSCRL();
        }
    };
    private static ThreadLocal<IValidationContext> CurrentContext = new ThreadLocal();
    private ISignatureContainerValidator signatureContainerValidator;
    private ISignatureContainerEntryValidator signatureContainerEntryValidator;
    private ITimestampValidator timestampValidator;
    private ISignatureEntryValidator signatureEntryValidator;
    private ICertificateValidator certificateValidator;
    private ICertificatePathBuilder certificatePathBuilder;
    private ICertificatePathValidator certificatePathValidator;
    private IOCSPService ocspService;
    private ICRLService crlService;

    public static IValidationContext get() {
        IValidationContext result = ValidationContext.getCurrent();
        if (result == null) {
            result = ValidationContext.getDefault();
        }
        return result;
    }

    public static IValidationContext getCurrent() {
        return CurrentContext.get();
    }

    public static IValidationContext getDefault() {
        return DefaultValidationContextFactory.get().createValidationContext((IArgs)Args.create());
    }

    public static void setCurrent(IValidationContext context) {
        CurrentContext.set(context);
    }

    @Override
    public ICertificatePathBuilder getCertificatePathBuilder() {
        if (this.certificatePathBuilder == null) {
            return NULL_CERTIFICATEPATHBUILDER;
        }
        return this.certificatePathBuilder;
    }

    @Override
    public ICertificatePathValidator getCertificatePathValidator() {
        if (this.certificatePathValidator == null) {
            return NULL_CERTIFICATEPATHVALIDATOR;
        }
        return this.certificatePathValidator;
    }

    @Override
    public ICertificateValidator getCertificateValidator() {
        if (this.certificateValidator == null) {
            return NULL_CERTIFICATEVALIDATOR;
        }
        return this.certificateValidator;
    }

    @Override
    public ICRLService getCRLService() {
        if (this.crlService == null) {
            return NULL_CRLSERVICE;
        }
        return this.crlService;
    }

    @Override
    public IOCSPService getOCSPService() {
        if (this.ocspService == null) {
            return NULL_OCSPSERVICE;
        }
        return this.ocspService;
    }

    public ISignatureContainerEntryValidator getSignatureContainerEntryValidator() {
        if (this.signatureContainerEntryValidator == null) {
            return NULL_SIGNATURECONTAINERENTRYVALIDATOR;
        }
        return this.signatureContainerEntryValidator;
    }

    @Override
    public ISignatureContainerValidator getSignatureContainerValidator() {
        if (this.signatureContainerValidator == null) {
            return NULL_SIGNATURECONTAINERVALIDATOR;
        }
        return this.signatureContainerValidator;
    }

    @Override
    public ISignatureEntryValidator getSignatureEntryValidator() {
        if (this.signatureEntryValidator == null) {
            return NULL_SIGNATUREENTRYVALIDATOR;
        }
        return this.signatureEntryValidator;
    }

    @Override
    public ITimestampValidator getTimestampValidator() {
        if (this.timestampValidator == null) {
            return NULL_TIMESTAMPVALIDATOR;
        }
        return this.timestampValidator;
    }

    public void setCertificatePathBuilder(ICertificatePathBuilder certificatePathBuilder) {
        this.certificatePathBuilder = certificatePathBuilder;
    }

    public void setCertificatePathValidator(ICertificatePathValidator certificatePathValidator) {
        this.certificatePathValidator = certificatePathValidator;
    }

    public void setCertificateValidator(ICertificateValidator certificateValidator) {
        this.certificateValidator = certificateValidator;
    }

    public void setCRLService(ICRLService crlService) {
        this.crlService = crlService;
    }

    public void setOCSPService(IOCSPService ocspService) {
        this.ocspService = ocspService;
    }

    public void setSignatureContainerEntryValidator(ISignatureContainerEntryValidator signatureContainerEntryValidator) {
        this.signatureContainerEntryValidator = signatureContainerEntryValidator;
    }

    public void setSignatureContainerValidator(ISignatureContainerValidator signatureContainerValidator) {
        this.signatureContainerValidator = signatureContainerValidator;
    }

    public void setSignatureEntryValidator(ISignatureEntryValidator signatureEntryValidator) {
        this.signatureEntryValidator = signatureEntryValidator;
    }

    public void setTimestampValidator(ITimestampValidator timestampValidator) {
        this.timestampValidator = timestampValidator;
    }
}

