/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.validation;

import de.intarsys.security.app.validation.ISignatureContainerValidator;
import de.intarsys.security.app.validation.ISignatureContainerValidatorFactory;
import de.intarsys.security.app.validation.IValidationParameters;
import de.intarsys.security.signature.ISignatureContainer;
import de.intarsys.security.signature.ISignatureContainerEntry;
import de.intarsys.security.signature.ISignatureEntry;
import de.intarsys.security.signature.ITimestampEntry;
import de.intarsys.security.standard.validation.VSSignatureContainer;
import de.intarsys.security.standard.validation.VSSignatureEntry;
import de.intarsys.security.standard.validation.VSTimestamp;
import de.intarsys.security.standard.validation.VSTimestampEntry;
import de.intarsys.security.validation.IVSSignatureContainer;
import de.intarsys.tools.adapter.AdapterTools;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.functor.IArgs;

public class StandardSignatureContainerValidatorFactory
implements ISignatureContainerValidatorFactory {
    private static final ISignatureContainerValidator UNAVAILABLE_VALIDATOR = new ISignatureContainerValidator(){

        public IVSSignatureContainer validate(ISignatureContainer<?> signatureContainer, IDigest digest, IValidationParameters parameters) {
            VSSignatureContainer state = new VSSignatureContainer(signatureContainer, 2);
            for (ISignatureContainerEntry entry : signatureContainer.getEntries()) {
                if (entry instanceof ISignatureEntry) {
                    VSSignatureEntry entryState = new VSSignatureEntry((ISignatureEntry)entry, 2);
                    state.addEntryState(entryState);
                    continue;
                }
                if (!(entry instanceof ITimestampEntry)) continue;
                ITimestampEntry timestampEntry = (ITimestampEntry)entry;
                VSTimestampEntry entryState = new VSTimestampEntry(timestampEntry, 2);
                VSTimestamp timestampState = new VSTimestamp(timestampEntry.getTimestamp(), 2);
                entryState.setTimestampState(timestampState);
                state.addEntryState(entryState);
            }
            return state;
        }
    };

    @Override
    public ISignatureContainerValidator createValidator(ISignatureContainer signatureContainer, IArgs args) {
        ISignatureContainerValidator validator = null;
        ISignatureContainerValidatorFactory validatorFactory = (ISignatureContainerValidatorFactory)AdapterTools.getAdapter((Object)signatureContainer, ISignatureContainerValidatorFactory.class, null);
        validator = validatorFactory == null ? (ISignatureContainerValidator)AdapterTools.getAdapter((Object)signatureContainer, ISignatureContainerValidator.class, null) : validatorFactory.createValidator(signatureContainer, args);
        if (validator == null) {
            validator = UNAVAILABLE_VALIDATOR;
        }
        return validator;
    }
}

