/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.algorithm.common;

import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.security.algorithm.common.PACKAGE;
import de.intarsys.security.standard.validation.commonpki.CryptoDates;
import de.intarsys.tools.date.DateEnvironment;
import de.intarsys.tools.date.DateTools;
import de.intarsys.tools.message.AliasMessage;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.string.StringTools;
import de.intarsys.tools.validation.CommonValidator;
import de.intarsys.tools.validation.ValidationResult;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Date;

public class WeakDigestAlgorithmValidator
extends CommonValidator<DigestAlgorithm> {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT);
    private final String role;

    public WeakDigestAlgorithmValidator() {
        this(null);
    }

    public WeakDigestAlgorithmValidator(String role) {
        this.role = role;
    }

    protected void basicValidate(ValidationResult result, DigestAlgorithm target) {
        this.checkDigestAlgorithm(result, target);
    }

    protected void checkDigestAlgorithm(ValidationResult result, DigestAlgorithm target) {
        LocalDate expirationDate;
        if (target == null || target.getName() == null) {
            return;
        }
        Date now = DateEnvironment.get().now();
        LocalDate nowDate = DateTools.toLocalDate((Date)now);
        if (nowDate.isAfter(expirationDate = CryptoDates.getExpirationForDigestAlgorithm(target.getName()))) {
            IMessage msg = Msg.getMessage("WeakDigestAlgorithmValidator.WarningWeakDigestAlgorithm", new Object[]{target.getName(), FORMATTER.format(expirationDate)});
            String code = StringTools.pathAppend((String)this.getRole(), (String)".", (String)"weakDigestAlgorithm");
            result.addWarning((IMessage)new AliasMessage(code, msg, new Object[0]));
        }
    }

    public String getRole() {
        return this.role;
    }
}

