/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.algorithm.common;

import de.intarsys.security.algorithm.common.Algorithm;
import java.util.HashMap;
import java.util.Map;

public class EncodingAlgorithm
extends Algorithm {
    private static final Map<String, EncodingAlgorithm> algorithms = new HashMap<String, EncodingAlgorithm>();
    public static final String NAME_PKCS1Type1 = "PKCS1Type1";
    public static final String NAME_PKCS1Type2 = "PKCS1Type2";
    public static final String NAME_ISO9796_2_S1 = "ISO9796-2-S1";
    public static final String NAME_Dinsig9769 = "Dinsig9796";
    public static final String NAME_PSS = "PSS";
    public static final String NAME_OAEP = "OAEP";
    public static final String NAME_X509 = "X509";
    public static final String NAME_NONE = "EncodingAlgorithm.none";
    public static final String NAME_UNDEFINED = "EncodingAlgorithm.undefined";
    public static final String NAME_UNKNOWN = "EncodingAlgorithm.unknown";
    public static final EncodingAlgorithm ALG_PKCS1Type1 = new EncodingAlgorithm("PKCS1Type1", null, null);
    public static final EncodingAlgorithm ALG_PKCS1Type2 = new EncodingAlgorithm("PKCS1Type2", null, null);
    public static final EncodingAlgorithm ALG_ISO9796_2_S1 = new EncodingAlgorithm("ISO9796-2-S1", null, null);
    public static final EncodingAlgorithm ALG_Dinsig9769 = new EncodingAlgorithm("Dinsig9796", null, null);
    public static final EncodingAlgorithm ALG_PSS = new EncodingAlgorithm("PSS", null, null);
    public static final EncodingAlgorithm ALG_OAEP = new EncodingAlgorithm("OAEP", null, null);
    public static final EncodingAlgorithm ALG_NONE = new EncodingAlgorithm("EncodingAlgorithm.none", null, null);
    public static final EncodingAlgorithm ALG_UNDEFINED = new EncodingAlgorithm("EncodingAlgorithm.undefined", null, null);
    public static final EncodingAlgorithm ALG_UNKNOWN = new EncodingAlgorithm("EncodingAlgorithm.unknown", null, null);

    public static EncodingAlgorithm lookupAlgorithm(String name) {
        return algorithms.get(name);
    }

    public static EncodingAlgorithm lookupAlgorithmCanonical(String name) {
        EncodingAlgorithm result = algorithms.get(name);
        return result == null ? null : result.getCanonical();
    }

    protected static void register(EncodingAlgorithm algorithm) {
        algorithms.put(algorithm.getName(), algorithm);
        algorithms.putIfAbsent(algorithm.getOid(), algorithm);
    }

    protected EncodingAlgorithm(String name, EncodingAlgorithm aliased) {
        this(name, aliased.getOid(), aliased);
    }

    public EncodingAlgorithm(String name, String oid, EncodingAlgorithm canonical) {
        super(name, oid, canonical);
        EncodingAlgorithm.register(this);
    }

    @Override
    public EncodingAlgorithm getCanonical() {
        return (EncodingAlgorithm)super.getCanonical();
    }

    static {
        new EncodingAlgorithm("ISO9796p2s1", ALG_ISO9796_2_S1);
        new EncodingAlgorithm("EMSA-PSS", ALG_PSS);
        new EncodingAlgorithm("", ALG_NONE);
    }
}

