/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.algorithm.common;

import java.util.Objects;

public abstract class Algorithm {
    private final String name;
    private final String oid;
    private final Algorithm canonical;

    protected Algorithm(String name, String oid, Algorithm canonical) {
        this.name = name;
        this.oid = oid;
        this.canonical = canonical == null ? this : canonical;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Algorithm) {
            Algorithm algorithm = (Algorithm)obj;
            if (this.oid == null) {
                return Objects.equals(this.name, algorithm.name);
            }
            return Objects.equals(this.oid, algorithm.oid);
        }
        return super.equals(obj);
    }

    public Algorithm getCanonical() {
        return this.canonical;
    }

    public String getCanonicalName() {
        return this.getCanonical().getName();
    }

    public String getName() {
        return this.name;
    }

    public String getOid() {
        return this.oid;
    }

    public int hashCode() {
        return Objects.hash(this.oid, this.name);
    }

    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        if (this.oid != null) {
            return this.oid;
        }
        return super.toString();
    }
}

