/*
 * Decompiled with CFR 0.152.
 */
package org.jempbox.xmp;

import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import org.jempbox.xmp.XMPMetadata;
import org.jempbox.xmp.XMPSchema;
import org.w3c.dom.Element;

public class XMPSchemaDublinCore
extends XMPSchema {
    public static final String NAMESPACE = "http://purl.org/dc/elements/1.1/";
    protected static final String basePrefix = "dc";
    protected static List<String> propertyNames = Arrays.asList("dc:contributor", "dc:coverage", "dc:creator", "dc:date", "dc:description", "dc:format", "dc:identifier", "dc:language", "dc:publisher", "dc:relation", "dc:rights", "dc:source", "dc:subject", "dc:title", "dc:type");

    public XMPSchemaDublinCore(Element element, String prefix) {
        super(element, prefix);
    }

    public XMPSchemaDublinCore(XMPMetadata parent) {
        super(parent, basePrefix, NAMESPACE);
    }

    public void addContributor(String contributor) {
        this.addBagValue(this.prefix + ":contributor", contributor);
    }

    public void addCreator(String creator) {
        this.addSequenceValue(this.prefix + ":creator", creator);
    }

    public void addDate(Calendar date) {
        this.addSequenceDateValue(this.prefix + ":date", date);
    }

    public void addLanguage(String language) {
        this.addBagValue(this.prefix + ":language", language);
    }

    public void addPublisher(String publisher) {
        this.addBagValue(this.prefix + ":publisher", publisher);
    }

    public void addRelation(String relation) {
        this.addBagValue(this.prefix + ":relation", relation);
    }

    public void addSubject(String subject) {
        this.addBagValue(this.prefix + ":subject", subject);
    }

    public List getContributors() {
        return this.getBagList(this.prefix + ":contributor");
    }

    public String getCoverage() {
        return this.getTextProperty(this.prefix + ":coverage");
    }

    public List getCreators() {
        return this.getSequenceList(this.prefix + ":creator");
    }

    public List getDates() throws IOException {
        return this.getSequenceDateList(this.prefix + ":date");
    }

    public String getDescription() {
        return this.getLanguageProperty(this.prefix + ":description", null);
    }

    public String getDescription(String language) {
        return this.getLanguageProperty(this.prefix + ":description", language);
    }

    public List getDescriptionLanguages() {
        return this.getLanguagePropertyLanguages(this.prefix + ":description");
    }

    public String getFormat() {
        return this.getTextProperty(this.prefix + ":format");
    }

    public String getIdentifier() {
        return this.getTextProperty(this.prefix + ":identifier");
    }

    public List getLanguages() {
        return this.getBagList(this.prefix + ":language");
    }

    @Override
    protected List<String> getPropertyNames() {
        return propertyNames;
    }

    public List getPublishers() {
        return this.getBagList(this.prefix + ":publisher");
    }

    public List getRelationships() {
        return this.getBagList(this.prefix + ":relation");
    }

    public String getRights() {
        return this.getLanguageProperty(this.prefix + ":rights", null);
    }

    public String getRights(String language) {
        return this.getLanguageProperty(this.prefix + ":rights", language);
    }

    public List getRightsLanguages() {
        return this.getLanguagePropertyLanguages(this.prefix + ":rights");
    }

    public String getSource() {
        return this.getTextProperty(this.prefix + ":source");
    }

    public List getSubjects() {
        return this.getBagList(this.prefix + ":subject");
    }

    public String getTitle() {
        return this.getLanguageProperty(this.prefix + ":title", null);
    }

    public String getTitle(String language) {
        return this.getLanguageProperty(this.prefix + ":title", language);
    }

    public List getTitleLanguages() {
        return this.getLanguagePropertyLanguages(this.prefix + ":title");
    }

    public String getType() {
        return this.getTextProperty(this.prefix + ":type");
    }

    public void removeContributor(String contributor) {
        this.removeBagValue(this.prefix + ":contributor", contributor);
    }

    public void removeCreator(String creator) {
        this.removeSequenceValue(this.prefix + ":creator", creator);
    }

    public void removeDate(Calendar date) {
        this.removeSequenceDateValue(this.prefix + ":date", date);
    }

    public void removeLanguage(String language) {
        this.removeBagValue(this.prefix + ":language", language);
    }

    public void removePublisher(String publisher) {
        this.removeBagValue(this.prefix + ":publisher", publisher);
    }

    public void removeRelation(String relation) {
        this.removeBagValue(this.prefix + ":relation", relation);
    }

    public void removeSubject(String subject) {
        this.removeBagValue(this.prefix + ":subject", subject);
    }

    public void setCoverage(String coverage) {
        this.setTextProperty(this.prefix + ":coverage", coverage);
    }

    public void setDescription(String description) {
        this.setLanguageProperty(this.prefix + ":description", null, description);
    }

    public void setDescription(String language, String description) {
        this.setLanguageProperty(this.prefix + ":description", language, description);
    }

    public void setFormat(String format) {
        this.setTextProperty(this.prefix + ":format", format);
    }

    public void setIdentifier(String id) {
        this.setTextProperty(this.prefix + ":identifier", id);
    }

    public void setRights(String rights) {
        this.setLanguageProperty(this.prefix + ":rights", null, rights);
    }

    public void setRights(String language, String rights) {
        this.setLanguageProperty(this.prefix + ":rights", language, rights);
    }

    public void setSource(String id) {
        this.setTextProperty(this.prefix + ":source", id);
    }

    public void setTitle(String title) {
        this.setLanguageProperty(this.prefix + ":title", null, title);
    }

    public void setTitle(String language, String title) {
        this.setLanguageProperty(this.prefix + ":title", language, title);
    }

    public void setType(String type) {
        this.setTextProperty(this.prefix + ":type", type);
    }
}

