/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.pdf.validation;

import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.MDPPermission;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDSignature;
import de.intarsys.pdf.pd.PDSignatureReference;
import de.intarsys.pdf.pd.PDTransformMethod;
import de.intarsys.pdf.pd.PDTransformParams;
import de.intarsys.pdf.signature.change.FieldValueChange;
import de.intarsys.pdf.signature.change.IPDFDocumentChange;
import de.intarsys.security.app.validation.ISignatureEntryValidator;
import de.intarsys.security.app.validation.IValidationParameters;
import de.intarsys.security.app.validation.SignatureEntryValidatorFactory;
import de.intarsys.security.app.validation.ValidationParameters;
import de.intarsys.security.method.pdf.signature.PDFSignatureContainer;
import de.intarsys.security.method.pdf.signature.PDFSignatureEntry;
import de.intarsys.security.method.pdf.signature.PDSignatureByteRange;
import de.intarsys.security.method.pdf.validation.IMDPPermissionPolicy;
import de.intarsys.security.method.pdf.validation.MDPPErmissionPolicy;
import de.intarsys.security.method.pdf.validation.PACKAGE;
import de.intarsys.security.method.pdf.validation.PDFChangeProvider;
import de.intarsys.security.method.pdf.validation.PDFSignatureContainerEntryValidator;
import de.intarsys.security.signature.ISignatureContainerEntry;
import de.intarsys.security.signature.ISignatureEntry;
import de.intarsys.security.standard.validation.CommonValidationMessages;
import de.intarsys.security.standard.validation.VSDigest;
import de.intarsys.security.standard.validation.VSMathematicalSignature;
import de.intarsys.security.standard.validation.VSModification;
import de.intarsys.security.standard.validation.VSSignature;
import de.intarsys.security.standard.validation.VSSignatureEntry;
import de.intarsys.security.standard.validation.ValidationMessage;
import de.intarsys.security.validation.IChangeProvider;
import de.intarsys.security.validation.IVSDigest;
import de.intarsys.security.validation.IVSModification;
import de.intarsys.security.validation.IVSSignature;
import de.intarsys.security.validation.IVSSignatureEntry;
import de.intarsys.security.validation.IValidationMessage;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.randomaccess.IRandomAccess;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class PDFSignatureEntryValidator
extends PDFSignatureContainerEntryValidator<PDFSignatureEntry, VSSignatureEntry>
implements ISignatureEntryValidator {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private static final Logger Log = LoggerFactory.getLogger(PDFSignatureEntryValidator.class);

    @Override
    protected void checkIncrementalChanges(IMDPPermissionPolicy permissionPolicy, VSModification state, PDFSignatureEntry signatureEntry) {
        super.checkIncrementalChanges(permissionPolicy, state, signatureEntry);
        List signatureReferences = signatureEntry.getPDSignature().getSignatureReferences();
        ArrayList<PDSignatureReference> additionalChecks = new ArrayList<PDSignatureReference>();
        if (signatureReferences != null) {
            for (PDSignatureReference reference : signatureReferences) {
                COSObject method = reference.getTransformMethod().cosGetObject();
                if (!PDTransformMethod.DK_FieldMDP.equals((Object)method)) continue;
                additionalChecks.add(reference);
            }
        }
        for (PDSignatureReference reference : additionalChecks) {
            this.checkSignatureReference(reference, state, signatureEntry);
        }
    }

    protected void checkSignatureReference(PDSignatureReference reference, VSModification state, PDFSignatureEntry signatureEntry) {
        PDTransformMethod method = reference.getTransformMethod();
        PDTransformParams params = reference.getTransformParams();
        if (PDTransformMethod.DK_FieldMDP.equals((Object)method.cosGetObject())) {
            this.checkSignatureReferenceFieldMDP(params, state, signatureEntry);
        }
    }

    protected void checkSignatureReferenceFieldMDP(PDTransformParams params, VSModification state, PDFSignatureEntry signatureEntry) {
        List changes;
        ArrayList<String> protectedFields = new ArrayList<String>();
        List fields = signatureEntry.getDoc().getAcroForm().collectLeafFields();
        for (PDAcroFormField field : fields) {
            boolean protect = true;
            if (params.isActionInclude()) {
                protect = params.getFields().contains(field.getQualifiedName());
            } else if (params.isActionExclude()) {
                boolean bl = protect = !params.getFields().contains(field.getQualifiedName());
            }
            if (!protect) continue;
            protectedFields.add(field.getQualifiedName());
        }
        try {
            changes = state.getChangeProvider().getSubsequentChanges();
        }
        catch (IOException e) {
            IValidationMessage msg = ValidationMessage.createError((String)Msg.getString("PDFSignatureEntryValidator.ErrorChangesUndetermined", new Object[0]));
            state.addMessage(msg);
            state.setState(2);
            return;
        }
        for (IPDFDocumentChange change : changes) {
            FieldValueChange fieldChange;
            String fieldName;
            if (!"field".equals(change.getType()) || !protectedFields.contains(fieldName = (fieldChange = (FieldValueChange)change).getFieldName())) continue;
            fieldChange.setSeverity(0);
            state.increaseChangeLevel(99);
            if (!this.isConsiderTransformations()) continue;
            state.increaseState(3);
        }
    }

    @Override
    protected VSSignatureEntry createTargetState(PDFSignatureEntry entry, int state) {
        return new VSSignatureEntry((ISignatureEntry)entry, state);
    }

    public boolean isSigning(ISignatureEntry signatureEntry, IDigest digest) {
        try {
            return this.validate(signatureEntry, digest, (IValidationParameters)new ValidationParameters()).isValid();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public IVSSignatureEntry validate(ISignatureEntry signatureEntry, IDigest digest, IValidationParameters parameters) {
        if (Log.isEnabledForLevel(Level.TRACE)) {
            Log.trace("Validating PDF signature...");
        }
        return (IVSSignatureEntry)super.validate((PDFSignatureEntry)signatureEntry, digest, parameters);
    }

    protected IVSSignatureEntry verify(PDFSignatureEntry entry, IDigest digest) throws IOException {
        ISignatureEntryValidator validator = SignatureEntryValidatorFactory.get().createValidator(entry.getBasicSignatureEntry(), (IArgs)Args.create());
        return (IVSSignatureEntry)validator.validate((ISignatureContainerEntry)entry.getBasicSignatureEntry(), digest, (IValidationParameters)new ValidationParameters());
    }

    @Override
    protected VSSignatureEntry verify(PDFSignatureEntry entry, PDFSignatureContainer container, IRandomAccess randomAccess, Optional<PDSignatureByteRange> byteRange, IValidationParameters parameters) throws IOException {
        VSSignatureEntry entryState = (VSSignatureEntry)this.verify(entry, new PDFSignatureContainer.DigestProvider(byteRange));
        PDSignature pdSignature = entry.getPDSignature();
        MDPPermission permissions = MDPPermission.Undefined;
        boolean isDefaultPermission = false;
        if (this.isConsiderTransformations()) {
            permissions = container.getPermissions();
        }
        if (permissions == MDPPermission.Undefined) {
            isDefaultPermission = true;
            permissions = this.getDefaultPermissions();
        }
        MDPPErmissionPolicy permissionPolicy = new MDPPErmissionPolicy(permissions, !isDefaultPermission);
        VSSignature signatureState = new VSSignature(entryState.getSignatureState());
        VSDigest digestState = new VSDigest();
        List digestStates = entryState.getSignatureState().getDigestStates();
        if (!digestStates.isEmpty()) {
            signatureState.removeDigestStates();
            Iterator i = digestStates.iterator();
            while (i.hasNext()) {
                IVSDigest current = (IVSDigest)i.next();
                if (i.hasNext()) {
                    signatureState.addDigestState(current);
                    continue;
                }
                digestState = new VSDigest(current);
            }
        }
        VSModification modificationState = new VSModification(0);
        modificationState.setChangeProvider((IChangeProvider)new PDFChangeProvider(entry));
        modificationState.setAttribute((Object)STATEATTR_PERMISSION, (Object)permissions);
        modificationState.setAttribute((Object)STATEATTR_DEFAULTPERMISSIONS, (Object)isDefaultPermission);
        digestState.setModificationState((IVSModification)modificationState);
        int signatureLength = pdSignature.getContentBytes().length;
        this.checkByteRange(byteRange, randomAccess, digestState, modificationState, signatureLength, entry, permissionPolicy);
        signatureState.addDigestState((IVSDigest)digestState);
        if (digestState.isUndefined()) {
            signatureState.increaseState(2);
        }
        entryState.setSignatureState((IVSSignature)signatureState);
        entryState.setModificationState((IVSModification)modificationState);
        return entryState;
    }

    protected IVSSignatureEntry verify(PDFSignatureEntry entry, PDFSignatureContainer.DigestProvider digestProvider) {
        VSSignature signatureStateError = new VSSignature((IDigest)null);
        try {
            IDigest dataDigest = digestProvider.getDigest(entry.getHashAlgorithmSpec());
            return this.verify(entry, dataDigest);
        }
        catch (NoSuchAlgorithmException e) {
            IValidationMessage message = CommonValidationMessages.ERROR_ALGORITHM_UNKNOWN((Exception)e, (String)entry.getHashAlgorithmSpec().getAlgorithm().getCanonicalName());
            signatureStateError.setSignatureState(VSMathematicalSignature.createInvalid((IValidationMessage)message));
            signatureStateError.addDigestState((IVSDigest)VSDigest.createInvalid((IValidationMessage)message));
        }
        catch (Exception e) {
            IValidationMessage message = CommonValidationMessages.ERROR_IO((Exception)e);
            signatureStateError.setSignatureState(VSMathematicalSignature.createInvalid((IValidationMessage)message));
            signatureStateError.addDigestState((IVSDigest)VSDigest.createInvalid((IValidationMessage)message));
        }
        VSSignatureEntry entryState = new VSSignatureEntry((ISignatureEntry)entry);
        entryState.setSignatureState((IVSSignature)signatureStateError);
        return entryState;
    }
}

