/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.pdf.signature;

import de.intarsys.asn1.cms.CMS;
import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1BasedTools;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.pd.PDSignature;
import de.intarsys.security.method.cms.signature.CMSSignatureContainer;
import de.intarsys.security.method.pdf.signature.ISignatureContainerFactory;
import de.intarsys.security.signature.ISignatureContainer;
import java.io.IOException;

public class SignatureFactoryETSICAdESDetached
implements ISignatureContainerFactory {
    public static final COSName CN_ETSI_CADES_DETACHED = COSName.constant((String)"ETSI.CAdES.detached");

    @Override
    public ISignatureContainer createSignatureContainer(PDSignature pdSignature) throws IOException {
        CMS cms;
        byte[] cmsBytes = pdSignature.getContentBytes();
        if (cmsBytes.length == 0) {
            return null;
        }
        try {
            cms = (CMS)ASN1BasedTools.create((ASN1Based.Factory)CMS.FACTORY, (byte[])cmsBytes);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Cannot parse CMS");
        }
        return new CMSSignatureContainer(cms);
    }

    @Override
    public COSName getEncoding() {
        return CN_ETSI_CADES_DETACHED;
    }

    @Override
    public COSName getName() {
        return null;
    }
}

