/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.pdf.signature;

import de.intarsys.pdf.cos.COSTools;
import de.intarsys.pdf.pd.MDPPermission;
import de.intarsys.pdf.pd.PDAFSignatureField;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDSignature;
import de.intarsys.pdf.pd.PDSignatureReference;
import de.intarsys.pdf.pd.PDTransformMethod;
import de.intarsys.security.algorithm.common.AlgorithmSpec;
import de.intarsys.security.app.validation.IDigestProvider;
import de.intarsys.security.app.validation.ISignatureContainerValidatorFactory;
import de.intarsys.security.method.cms.timestamp.TimestampTokenContainer;
import de.intarsys.security.method.pdf.common.PDSignatureTools;
import de.intarsys.security.method.pdf.signature.DocumentChangeLog;
import de.intarsys.security.method.pdf.signature.IDocumentChangeLog;
import de.intarsys.security.method.pdf.signature.PDFEmbeddedSignatureContainerFactory;
import de.intarsys.security.method.pdf.signature.PDFSignatureContainerEntry;
import de.intarsys.security.method.pdf.signature.PDFSignatureEntry;
import de.intarsys.security.method.pdf.signature.PDFTimestampEntry;
import de.intarsys.security.method.pdf.signature.PDSignatureByteRange;
import de.intarsys.security.method.pdf.validation.PDFSignatureContainerValidatorFactory;
import de.intarsys.security.signature.AbstractSignatureContainer;
import de.intarsys.security.signature.ISignatureContainer;
import de.intarsys.security.signature.ISignatureEntry;
import de.intarsys.security.signature.UnknownSignatureContainer;
import de.intarsys.security.timestamp.ITimestampToken;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigester;
import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.wrapper.AttributeChangeListener;
import de.intarsys.tools.locator.ILocator;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class PDFSignatureContainer
extends AbstractSignatureContainer<PDFSignatureContainerEntry> {
    private static final Object ATTR_SIGNATURE_CONTAINER = new Object();
    private static final Logger Log = LoggerFactory.getLogger(PDFSignatureContainer.class);
    private AttributeChangeListener listenLocatorChanged = new AttributeChangeListener("locator"){

        public void handleAttributeChange(AttributeChangedEvent event) {
            PDFSignatureContainer.this.locatorChanged((ILocator)event.getOldValue(), (ILocator)event.getNewValue());
        }
    };
    private List<PDFSignatureContainerEntry> entries;
    private IDocumentChangeLog changeLog;

    public static PDFSignatureContainer createSignatureContainer(PDDocument doc) {
        PDFSignatureContainer container = (PDFSignatureContainer)((Object)doc.getAttribute(ATTR_SIGNATURE_CONTAINER));
        if (container == null) {
            container = new PDFSignatureContainer(doc);
            doc.setAttribute(ATTR_SIGNATURE_CONTAINER, (Object)container);
        }
        return container;
    }

    protected PDFSignatureContainer(PDDocument doc) {
        super((Object)doc);
        this.arm();
    }

    protected void arm() {
        this.getDoc().cosGetDoc().stGetDoc().addNotificationListener(AttributeChangedEvent.ID, (INotificationListener)this.listenLocatorChanged);
    }

    protected List<PDFSignatureContainerEntry> collectEntries(List<PDAFSignatureField> signedFields, Map<PDSignature, PDFSignatureContainerEntry> entryMap) {
        ArrayList<PDFSignatureContainerEntry> result = new ArrayList<PDFSignatureContainerEntry>(signedFields.size());
        for (PDAFSignatureField field : signedFields) {
            PDSignature signature = field.getSignature();
            PDFSignatureContainerEntry entry = entryMap.get(signature);
            if (entry == null) {
                entry = this.createEntry(signature);
            }
            if (entry == null) continue;
            result.add(entry);
        }
        result.sort((e1, e2) -> {
            COSTools.IRevision r1 = e1.getSignedRevision();
            COSTools.IRevision r2 = e2.getSignedRevision();
            if (r1 == null || r2 == null) {
                return 0;
            }
            return Long.compare(r1.getLength(), r2.getLength());
        });
        return result;
    }

    protected PDFSignatureContainerEntry createEntry(PDSignature signature) {
        ISignatureContainer container;
        try {
            container = PDFEmbeddedSignatureContainerFactory.instance().createSignatureContainer(signature);
        }
        catch (IOException e) {
            Log.warn(e.getMessage(), (Throwable)e);
            container = new UnknownSignatureContainer((Exception)e, false);
        }
        catch (GeneralSecurityException e) {
            if (Log.isEnabledForLevel(Level.TRACE)) {
                Log.trace(e.getMessage(), (Throwable)e);
            }
            container = new UnknownSignatureContainer((Exception)e, false);
        }
        if (container instanceof TimestampTokenContainer) {
            ITimestampToken timestamp = ((TimestampTokenContainer)container).getEntry().getTimestamp();
            return new PDFTimestampEntry(this, signature, timestamp);
        }
        if (container != null && container.getSize() > 0) {
            ISignatureEntry entry = (ISignatureEntry)container.getEntries().get(0);
            return new PDFSignatureEntry(this, signature, entry);
        }
        return null;
    }

    protected ISignatureContainerValidatorFactory createSignatureContainerValidatorFactory() {
        return new PDFSignatureContainerValidatorFactory();
    }

    protected void disarm() {
        this.getDoc().cosGetDoc().stGetDoc().removeNotificationListener(AttributeChangedEvent.ID, (INotificationListener)this.listenLocatorChanged);
    }

    public byte[] getBytes() {
        return null;
    }

    public PDFSignatureEntry getCertificationSignatureEntry() {
        for (PDFSignatureContainerEntry entry : this.getEntries()) {
            PDFSignatureEntry signatureEntry;
            if (!(entry instanceof PDFSignatureEntry) || !(signatureEntry = (PDFSignatureEntry)entry).isCertificationSignature()) continue;
            return signatureEntry;
        }
        return null;
    }

    public String getContentType() {
        return "application/pdf";
    }

    protected PDDocument getDoc() {
        return (PDDocument)this.getImpl();
    }

    public synchronized IDocumentChangeLog getDocumentChangeLog() {
        if (this.changeLog == null) {
            this.changeLog = DocumentChangeLog.create(this.getDoc());
        }
        return this.changeLog;
    }

    public synchronized List<PDFSignatureContainerEntry> getEntries() {
        List<PDAFSignatureField> signedFields = this.getSignedFields();
        if (this.entries == null || signedFields.size() != this.entries.size()) {
            HashMap<PDSignature, PDFSignatureContainerEntry> entryMap = new HashMap<PDSignature, PDFSignatureContainerEntry>();
            if (this.entries != null) {
                for (PDFSignatureContainerEntry entry : this.entries) {
                    entryMap.put(entry.getPDSignature(), entry);
                }
            }
            this.entries = this.collectEntries(signedFields, entryMap);
        }
        return Collections.unmodifiableList(this.entries);
    }

    public PDFSignatureContainerEntry getEntry(PDSignature signature) {
        for (PDFSignatureContainerEntry entry : this.getEntries()) {
            if (entry.getPDSignature() != signature) continue;
            return entry;
        }
        return null;
    }

    public ILocator getLocator() {
        return this.getDoc().getLocator();
    }

    public MDPPermission getPermissions() {
        PDSignatureReference reference;
        PDFSignatureEntry certificationEntry = this.getCertificationSignatureEntry();
        if (certificationEntry != null && (reference = certificationEntry.getSignatureReference(PDTransformMethod.DK_DocMDP)) != null) {
            return reference.getTransformParams().getPermissions();
        }
        return MDPPermission.Undefined;
    }

    private List<PDAFSignatureField> getSignedFields() {
        return PDSignatureTools.getSignedFields(this.getDoc());
    }

    public String getTypedName() {
        return this.getLocator().getName();
    }

    public static class DigestProvider
    implements IDigestProvider {
        private final Optional<PDSignatureByteRange> byteRange;

        public DigestProvider(Optional<PDSignatureByteRange> byteRange) {
            this.byteRange = byteRange;
        }

        public IDigest getDigest(AlgorithmSpec digestAlgorithmSpec) throws NoSuchAlgorithmException, IOException {
            if (!this.byteRange.isPresent()) {
                throw new IOException("No byte range available.");
            }
            if (digestAlgorithmSpec == null) {
                throw new IOException("no digest algorithm specified");
            }
            IDigester digester = DigestTools.createDigester((String)digestAlgorithmSpec.getAlgorithm().getCanonicalName());
            return DigestTools.digest((IDigester)digester, (InputStream)this.byteRange.get());
        }
    }
}

