/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.pdf.signature;

import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.pd.PDSignature;
import de.intarsys.security.method.pdf.signature.ISignatureContainerFactory;
import de.intarsys.security.method.pdf.signature.SignatureFactoryETSICAdESDetached;
import de.intarsys.security.method.pdf.signature.SignatureFactoryETSIRFC3161;
import de.intarsys.security.method.pdf.signature.SignatureFactoryPkcs7Detached;
import de.intarsys.security.method.pdf.signature.SignatureFactoryPkcs7Sha1;
import de.intarsys.security.method.pdf.signature.SignatureFactoryUnknown;
import de.intarsys.security.method.pdf.signature.SignatureFactoryX509RsaSha1;
import de.intarsys.security.signature.ISignatureContainer;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;

public class PDFEmbeddedSignatureContainerFactory {
    private static PDFEmbeddedSignatureContainerFactory INSTANCE;
    private Map encodingMap;
    private Map nameMap = new HashMap(5);
    private ISignatureContainerFactory unknownFactory;

    public static PDFEmbeddedSignatureContainerFactory instance() {
        if (INSTANCE == null) {
            INSTANCE = new PDFEmbeddedSignatureContainerFactory();
        }
        return INSTANCE;
    }

    private PDFEmbeddedSignatureContainerFactory() {
        this.encodingMap = new HashMap(5);
        this.unknownFactory = new SignatureFactoryUnknown();
        this.register(new SignatureFactoryPkcs7Sha1());
        this.register(new SignatureFactoryX509RsaSha1());
        this.register(new SignatureFactoryPkcs7Detached());
        this.register(new SignatureFactoryETSICAdESDetached());
        this.register(new SignatureFactoryETSIRFC3161());
    }

    public ISignatureContainer createSignatureContainer(PDSignature signature) throws IOException, GeneralSecurityException {
        ISignatureContainerFactory factory = this.lookupFactory(signature.getFilter(), signature.getSubFilter());
        if (factory != null) {
            return factory.createSignatureContainer(signature);
        }
        return null;
    }

    protected Map getEncodingMap() {
        return this.encodingMap;
    }

    protected Map getNameMap() {
        return this.nameMap;
    }

    public ISignatureContainerFactory lookupFactory(COSName name, COSName encoding) {
        ISignatureContainerFactory result = null;
        if (name != null) {
            result = this.lookupFactoryForName(name);
        }
        if (result == null) {
            result = this.lookupFactoryForEncoding(encoding);
        }
        if (result == null) {
            return this.unknownFactory;
        }
        return result;
    }

    public ISignatureContainerFactory lookupFactoryForEncoding(COSName encoding) {
        return (ISignatureContainerFactory)this.getEncodingMap().get(encoding);
    }

    public ISignatureContainerFactory lookupFactoryForName(COSName name) {
        return (ISignatureContainerFactory)this.getNameMap().get(name);
    }

    public void register(ISignatureContainerFactory factory) {
        if (factory.getName() != null) {
            this.getNameMap().put(factory.getName(), factory);
        }
        if (factory.getEncoding() != null) {
            this.getEncodingMap().put(factory.getEncoding(), factory);
        }
    }
}

