/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.pdf.signature;

import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.pd.PDSignature;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.IDevice;
import de.intarsys.security.method.pdf.signature.AbstractStoreSignatureField;
import de.intarsys.security.method.pdf.signature.CommonPDDocumentSignatureEncoder;
import de.intarsys.security.method.pdf.signature.IStoreSignatureField;
import de.intarsys.security.method.pdf.signature.PDSignatureByteRange;
import de.intarsys.security.signature.common.ISignatureData;
import de.intarsys.security.signature.common.IToBeSignedData;
import de.intarsys.security.signature.common.SignatureData;
import de.intarsys.security.signature.common.ToBeSignedData;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.driver.ConversationDriver;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigester;
import de.intarsys.tools.exception.ExceptionTools;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateEncodingException;
import java.util.concurrent.ExecutionException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DEROctetString;

public class DSEX509RSASHA1
extends CommonPDDocumentSignatureEncoder {
    private static final COSName CN_ADOBE_X509_RSA_SHA1 = COSName.constant((String)"adbe.x509.rsa_sha1");
    private IDigester digester;
    private ISigner signer;

    public DSEX509RSASHA1(ISigner signer) {
        this(signer, DigestTools.createDigesterSHA1());
    }

    public DSEX509RSASHA1(ISigner signer, IDigester digester) {
        this.signer = signer;
        this.digester = digester;
    }

    @Override
    protected IStoreSignatureField createStoreSignatureField() {
        return new StoreSignatureField();
    }

    public IDigester getDigester() {
        return this.digester;
    }

    public ISigner getSigner() {
        return this.signer;
    }

    private class StoreSignatureField
    extends AbstractStoreSignatureField {
        private int keySize;
        private IX509PublicKeyCertificate[] certChain;

        public StoreSignatureField() {
            super(CN_ADOBE_PPKLITE, CN_ADOBE_X509_RSA_SHA1);
            this.certChain = new IX509PublicKeyCertificate[0];
        }

        private void addCertificates() {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            try {
                for (int k = 0; k < this.certChain.length; ++k) {
                    bout.write(this.certChain[k].getEncoded());
                }
            }
            catch (CertificateEncodingException certificateEncodingException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.getPdSignature().setCert(bout.toByteArray());
        }

        @Override
        protected byte[] encodeContent(byte[] content) throws IOException {
            if (content == null) {
                return null;
            }
            return ASN1Tools.toByteArray((ASN1Encodable[])new ASN1Encodable[]{new DEROctetString(content)});
        }

        @Override
        protected int getContentSize() {
            if (this.getKeySize() < 256) {
                return this.getKeySize() + 3;
            }
            return this.getKeySize() + 4;
        }

        @Override
        protected IDevice getDevice() {
            return DSEX509RSASHA1.this.getSigner().getDevice();
        }

        public int getKeySize() {
            return this.keySize;
        }

        @Override
        public void initialize(PDSignature pdSignature) {
            super.initialize(pdSignature);
            this.addCertificates();
        }

        @Override
        protected ISignatureData signByteRange(PDSignatureByteRange byteRange) throws SecurityApplicationException, IOException {
            IDigest digest = DigestTools.digest((IDigester)DSEX509RSASHA1.this.getDigester(), (InputStream)byteRange);
            try {
                IConversation conversation = DSEX509RSASHA1.this.getSigner().sign((IToBeSignedData)ToBeSignedData.create((IDigest)digest));
                ISignatureData signature = (ISignatureData)ConversationDriver.get().get(conversation);
                return SignatureData.create((byte[])signature.getEncodedSignature());
            }
            catch (ExecutionException e) {
                throw (SecurityApplicationException)ExceptionTools.unwrapTyped((Throwable)e, SecurityApplicationException.class);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SecurityApplicationException((Throwable)e);
            }
        }
    }
}

