/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.pdf.common;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NumericVersion {
    private static final Pattern PATTERN = Pattern.compile("\\D*([\\d|\\.]*).*");
    private String value;
    private String[] components;

    public NumericVersion(String value) {
        this.value = value;
        Matcher matcher = PATTERN.matcher(value);
        if (matcher.matches()) {
            String match = matcher.group(1);
            this.components = match.split("\\.");
        } else {
            this.components = new String[0];
        }
    }

    public int get(int index) {
        if (index < this.components.length) {
            return Integer.parseInt(this.components[index]);
        }
        return 0;
    }

    public int getMajor() {
        return this.get(0);
    }

    public int getMicro() {
        return this.get(2);
    }

    public int getMinor() {
        return this.get(1);
    }

    public String toString() {
        return this.value;
    }
}

