/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.signature.history;

import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSIndirectObject;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontDescriptor;
import de.intarsys.pdf.font.PDFontDescriptorEmbedded;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.pd.PDObject;
import de.intarsys.pdf.signature.change.AllowedChange;
import de.intarsys.pdf.signature.change.DefaultChange;
import de.intarsys.pdf.signature.history.HistoryTools;
import de.intarsys.pdf.signature.history.IChangeIdentifier;
import de.intarsys.pdf.signature.history.IChangeIdentifierContext;
import de.intarsys.pdf.signature.history.PACKAGE;
import de.intarsys.security.validation.IDocumentChange;
import de.intarsys.tools.message.IMessageBundle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FontChangeIdentifier
implements IChangeIdentifier {
    private static final IMessageBundle Msg = PACKAGE.Messages;

    protected List<IDocumentChange> basicCompareFont(COSIndirectObject baseObject, COSDictionary baseDict, COSDictionary newDict, final IChangeIdentifierContext context) throws IOException, COSLoadException {
        ArrayList<IDocumentChange> changes = new ArrayList<IDocumentChange>();
        if (baseDict == null) {
            if (newDict != null) {
                changes.add(new AllowedChange(Msg.getString("FontChangeIdentifier.MessageFontAdded", new Object[]{baseObject.getKey()})));
            }
        } else if (newDict == null) {
            changes.add(new DefaultChange(Msg.getString("FontChangeIdentifier.MessageFontRemoved", new Object[]{baseObject.getKey()})));
        } else {
            final boolean[] embedded = new boolean[]{false};
            final boolean[] changed = new boolean[]{false};
            HistoryTools.compareDictionary(baseDict, newDict, new HistoryTools.IEntryComparator(){

                @Override
                public void compare(COSName key, COSObject baseEntry, COSObject newEntry) throws IOException, COSLoadException {
                    if (HistoryTools.skipCompare(baseEntry, newEntry)) {
                        return;
                    }
                    if (!HistoryTools.equals(baseEntry, newEntry)) {
                        if (PDFont.DK_FirstChar.equals((Object)key) || PDFont.DK_LastChar.equals((Object)key) || PDFont.DK_Widths.equals((Object)key) || PDFont.DK_FontDescriptor.equals((Object)key)) {
                            if (baseEntry.isNull()) {
                                embedded[0] = true;
                            } else {
                                changed[0] = true;
                            }
                        } else {
                            changed[0] = true;
                        }
                    }
                    HistoryTools.setProcessed(context, baseEntry, newEntry);
                }
            });
            if (embedded[0]) {
                changes.add(new AllowedChange(Msg.getString("FontChangeIdentifier.MessageFontEmbedded", new Object[]{baseObject.getKey()})));
            }
            if (changed[0]) {
                changes.add(new DefaultChange(Msg.getString("FontChangeIdentifier.MessageFontChanged", new Object[]{baseObject.getKey()})));
            }
        }
        return changes;
    }

    protected List<IDocumentChange> compareFont(COSIndirectObject baseObject, COSIndirectObject newObject, IChangeIdentifierContext context) throws IOException, COSLoadException {
        if (context.isProcessed(baseObject)) {
            return Collections.emptyList();
        }
        context.setProcessed(baseObject);
        COSDictionary baseDict = baseObject.dereference().asDictionary();
        COSDictionary newDict = newObject.dereference().asDictionary();
        return this.basicCompareFont(baseObject, baseDict, newDict, context);
    }

    protected List<IDocumentChange> compareFontDescriptor(COSIndirectObject baseObject, COSIndirectObject newObject, final IChangeIdentifierContext context) throws IOException, COSLoadException {
        if (context.isProcessed(baseObject)) {
            return Collections.emptyList();
        }
        context.setProcessed(baseObject);
        ArrayList<IDocumentChange> changes = new ArrayList<IDocumentChange>();
        COSDictionary baseDict = baseObject.dereference().asDictionary();
        COSDictionary newDict = newObject.dereference().asDictionary();
        if (baseDict != null && newDict != null) {
            final boolean[] embedded = new boolean[]{false};
            final boolean[] changed = new boolean[]{false};
            HistoryTools.compareDictionary(baseDict, newDict, new HistoryTools.IEntryComparator(){

                @Override
                public void compare(COSName key, COSObject baseEntry, COSObject newEntry) throws IOException, COSLoadException {
                    if (HistoryTools.skipCompare(baseEntry, newEntry)) {
                        return;
                    }
                    if (!HistoryTools.equals(baseEntry, newEntry)) {
                        if (PDFontDescriptorEmbedded.DK_FontFile.equals((Object)key) || PDFontDescriptorEmbedded.DK_FontFile2.equals((Object)key) || PDFontDescriptorEmbedded.DK_FontFile3.equals((Object)key)) {
                            if (baseEntry.isNull()) {
                                embedded[0] = true;
                            } else {
                                changed[0] = true;
                            }
                        } else {
                            changed[0] = true;
                        }
                    }
                    HistoryTools.setProcessed(context, baseEntry, newEntry);
                }
            });
            if (embedded[0]) {
                changes.add(new AllowedChange(Msg.getString("FontChangeIdentifier.MessageFontEmbedded", new Object[]{baseObject.getKey()})));
            }
            if (changed[0]) {
                changes.add(new DefaultChange(Msg.getString("FontChangeIdentifier.MessageFontChanged", new Object[]{baseObject.getKey()})));
            }
        }
        return changes;
    }

    @Override
    public List<IDocumentChange> identifyChange(COSIndirectObject baseObject, COSIndirectObject newObject, IChangeIdentifierContext context) throws IOException, COSLoadException {
        COSDictionary baseDict = baseObject.dereference().asDictionary();
        if (baseDict != null) {
            if (PDFont.CN_Type_Font.equals((Object)baseDict.get(PDObject.DK_Type))) {
                return this.compareFont(baseObject, newObject, context);
            }
            if (PDFontDescriptor.CN_Type_FontDescriptor.equals((Object)baseDict.get(PDObject.DK_Type))) {
                return this.compareFontDescriptor(baseObject, newObject, context);
            }
        }
        return Collections.emptyList();
    }
}

