/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.signature.history;

import de.intarsys.pdf.cos.COSDocument;
import de.intarsys.pdf.cos.COSIndirectObject;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.signature.change.UnknownChange;
import de.intarsys.pdf.signature.history.ChangeIdentifierRegistry;
import de.intarsys.pdf.signature.history.IChangeIdentifier;
import de.intarsys.pdf.signature.history.IChangeIdentifierContext;
import de.intarsys.security.validation.IDocumentChange;
import de.intarsys.tools.attribute.AttributeMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ChangeIdentifierContext
implements IChangeIdentifierContext {
    private static final IndirectObjectComparator INDIRECT_OBJECT_COMPARATOR = new IndirectObjectComparator();
    private COSDocument baseDocument;
    private COSDocument newDocument;
    private Map<COSIndirectObject, COSIndirectObject> changedObjects = new LinkedHashMap<COSIndirectObject, COSIndirectObject>();
    private Set<COSIndirectObject> processedObjects;
    private Set<COSIndirectObject> remainingObjects;
    private Set<COSIndirectObject> unknownObjects;
    private final AttributeMap attributes = new AttributeMap();

    protected static <T> void add(Collection<T> set, T object, Comparator<T> comparator) {
        if (ChangeIdentifierContext.contains(set, object, comparator)) {
            return;
        }
        set.add(object);
    }

    protected static <T> boolean contains(Collection<T> set, T object, Comparator<T> comparator) {
        for (T element : set) {
            if (comparator.compare(element, object) != 0) continue;
            return true;
        }
        return false;
    }

    protected static <T> void remove(Collection<T> set, T object, Comparator<T> comparator) {
        for (T element : new ArrayList<T>(set)) {
            if (comparator.compare(element, object) != 0) continue;
            set.remove(element);
            return;
        }
    }

    public void addChangedObject(COSIndirectObject baseObject, COSIndirectObject newObject) {
        this.changedObjects.put(baseObject, newObject);
    }

    public final Object getAttribute(Object key) {
        return this.attributes.getAttribute(key);
    }

    @Override
    public COSDocument getBaseDocument() {
        return this.baseDocument;
    }

    public Map<COSIndirectObject, COSIndirectObject> getChangedObjects() {
        return this.changedObjects;
    }

    @Override
    public COSDocument getNewDocument() {
        return this.newDocument;
    }

    public Set<COSIndirectObject> getProcessedObjects() {
        return this.processedObjects;
    }

    public Set<COSIndirectObject> getRemainingObjects() {
        return this.remainingObjects;
    }

    protected List<IDocumentChange> identifyChange(COSIndirectObject baseObject, COSIndirectObject newObject) throws IOException, COSLoadException {
        ArrayList<IDocumentChange> changes = new ArrayList<IDocumentChange>();
        for (IChangeIdentifier identifier : ChangeIdentifierRegistry.get().getIdentifiers()) {
            changes.addAll(identifier.identifyChange(baseObject, newObject, this));
            if (!this.isProcessed(baseObject)) continue;
            break;
        }
        return changes;
    }

    @Override
    public boolean isProcessed(COSIndirectObject object) {
        if (object == null) {
            return false;
        }
        return ChangeIdentifierContext.contains(this.getProcessedObjects(), object, INDIRECT_OBJECT_COMPARATOR);
    }

    public List<IDocumentChange> process() throws IOException, COSLoadException {
        this.remainingObjects = new LinkedHashSet<COSIndirectObject>(this.changedObjects.keySet());
        this.processedObjects = new HashSet<COSIndirectObject>();
        this.unknownObjects = new LinkedHashSet<COSIndirectObject>();
        this.attributes.clear();
        ArrayList<IDocumentChange> changes = new ArrayList<IDocumentChange>();
        while (!this.remainingObjects.isEmpty()) {
            changes.addAll(this.processNext());
        }
        for (COSIndirectObject unkown : this.unknownObjects) {
            if (this.isProcessed(unkown)) continue;
            changes.add(new UnknownChange(unkown.getKey().toString()));
        }
        return changes;
    }

    protected List<IDocumentChange> processNext() throws IOException, COSLoadException {
        ArrayList<IDocumentChange> changes = new ArrayList<IDocumentChange>();
        COSIndirectObject baseObject = this.remainingObjects.iterator().next();
        COSIndirectObject newObject = this.getChangedObjects().get(baseObject);
        changes.addAll(this.identifyChange(baseObject, newObject));
        if (!this.isProcessed(baseObject)) {
            this.setUnknown(baseObject);
        }
        return changes;
    }

    public final Object removeAttribute(Object key) {
        return this.attributes.removeAttribute(key);
    }

    public final Object setAttribute(Object key, Object value) {
        return this.attributes.setAttribute(key, value);
    }

    public void setBaseDocument(COSDocument baseDocument) {
        this.baseDocument = baseDocument;
    }

    public void setNewDocument(COSDocument newDocument) {
        this.newDocument = newDocument;
    }

    @Override
    public void setProcessed(COSIndirectObject object) {
        if (object == null) {
            return;
        }
        ChangeIdentifierContext.add(this.processedObjects, object, INDIRECT_OBJECT_COMPARATOR);
        ChangeIdentifierContext.remove(this.remainingObjects, object, INDIRECT_OBJECT_COMPARATOR);
    }

    protected void setUnknown(COSIndirectObject object) {
        if (object == null) {
            return;
        }
        ChangeIdentifierContext.add(this.unknownObjects, object, INDIRECT_OBJECT_COMPARATOR);
        ChangeIdentifierContext.remove(this.remainingObjects, object, INDIRECT_OBJECT_COMPARATOR);
    }

    private static class IndirectObjectComparator
    implements Comparator<COSIndirectObject> {
        private IndirectObjectComparator() {
        }

        @Override
        public int compare(COSIndirectObject o1, COSIndirectObject o2) {
            if (o1.getObjectNumber() == o2.getObjectNumber()) {
                if (o1.getGenerationNumber() == o2.getGenerationNumber()) {
                    return 0;
                }
                if (o1.getGenerationNumber() < o2.getGenerationNumber()) {
                    return -1;
                }
                return 1;
            }
            if (o1.getObjectNumber() < o2.getObjectNumber()) {
                return -1;
            }
            return 1;
        }
    }
}

